/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.enchant;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.enchant.MahoujinProjectorEnchant;
import stepsword.mahoutsukai.enchant.ModEnchantments;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.enchant.ProjectorValues;
import stepsword.mahoutsukai.render.tile.MahoujinProjectorRenderer;
import stepsword.mahoutsukai.util.ClientImageDownloadUtil;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderProjectorEnchant {
    public static int rindex = 0;

    public static void renderProjectorEnchantment(RenderLivingEvent.Pre event) {
        LivingEntity living = event.getEntity();
        if (living != null) {
            Iterable armor = living.func_184193_aE();
            int x = 0;
            if (armor != null) {
                for (ItemStack stack : armor) {
                    float pitch;
                    float offset;
                    CompoundNBT nbt;
                    ++x;
                    if (!EffectUtil.hasEnchantment(stack, ModEnchantments.PROJECTOR) || (nbt = MahoujinProjectorEnchant.getProjectorNBT(stack)) == null) continue;
                    ProjectorValues te = new ProjectorValues();
                    te.read(nbt);
                    MatrixStack m = event.getMatrixStack();
                    m.func_227860_a_();
                    if (stack.func_77973_b() != living.func_184582_a(EquipmentSlotType.HEAD).func_77973_b()) {
                        offset = event.getEntity().field_70760_ar + (event.getEntity().field_70761_aq - event.getEntity().field_70760_ar) * event.getPartialRenderTick();
                        pitch = 0.0f;
                    } else {
                        offset = event.getEntity().field_70126_B + (event.getEntity().field_70177_z - event.getEntity().field_70126_B) * event.getPartialRenderTick();
                        pitch = event.getEntity().field_70127_C + (event.getEntity().field_70125_A - event.getEntity().field_70127_C) * event.getPartialRenderTick();
                    }
                    RenderUtils.rotateQ(-offset, 0.0f, 1.0f, 0.0f, m);
                    RenderProjectorEnchant.projectorRender(te, m, event.getPartialRenderTick(), event.getEntity().field_70170_p, 0.0f, 0.0f);
                    m.func_227865_b_();
                }
            }
        }
    }

    public static void projectorRender(ProjectorValues te, MatrixStack matrix, float partialTicks, World world, float addpitch, float addyaw) {
        RenderType type;
        if (rindex == 0x7FFFFFFD) {
            rindex = 0;
        }
        float time = ClientHandler.clientTickCounter;
        float offsetx = te.getCx();
        float offsety = te.getCy();
        float offsetz = te.getCz();
        float r = (float)te.getCr() / 255.0f;
        float g = (float)te.getCg() / 255.0f;
        float b = (float)te.getCb() / 255.0f;
        float a = (float)te.getCa() / 255.0f;
        float rotation = te.getRotation() + te.getCspeed() * time;
        float yaw = te.getCyaw() + te.getCyspeed() * time;
        float pitch = te.getCpitch() + te.getCpspeed() * time;
        float orbit = te.getCorbitspeed() * time;
        float speed = te.getCspeed();
        float ring = te.getCringangle();
        float size = te.getCsize();
        yaw = yaw - te.getCyspeed() + te.getCyspeed() * partialTicks + addyaw;
        pitch = pitch - te.getCpspeed() + te.getCpspeed() * partialTicks + addpitch;
        rotation = te.getRotationOffset() + (rotation - speed) + speed * partialTicks;
        matrix.func_227860_a_();
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        float preyaw = te.getCpreyaw();
        float prepitch = te.getCprepitch();
        orbit = orbit - te.getCorbitspeed() + te.getCorbitspeed() * partialTicks;
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(prepitch));
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(preyaw));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(orbit));
        matrix.func_227861_a_((double)offsetx, (double)offsety, (double)offsetz);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw));
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        int loadImage = te.getImage();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        if (loadImage >= 0) {
            for (int j = 0; j < MTConfig.MAGIC_CIRCLES.size(); ++j) {
                ClientImageDownloadUtil.download("circle" + j, MTConfig.MAGIC_CIRCLES.get(j), false);
            }
            if (loadImage < ClientImageDownloadUtil.lst.size()) {
                try {
                    type = MahoujinRenderType.createMahoujinRenderType(ClientImageDownloadUtil.lst.get(loadImage), 0, false);
                }
                catch (Exception e) {
                    type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false);
                }
            } else {
                type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false);
            }
        } else {
            type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false);
        }
        int lightmapX = 240;
        int lightmapY = 240;
        if (te.getShowCircle()) {
            IVertexBuilder builder = buffer.getBuffer(type);
            builder.func_227888_a_(positionMatrix, -0.5f * size, 0.0f, -0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            builder.func_227888_a_(positionMatrix, -0.5f * size, 0.0f, 0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            builder.func_227888_a_(positionMatrix, 0.5f * size, 0.0f, 0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            builder.func_227888_a_(positionMatrix, 0.5f * size, 0.0f, -0.5f * size).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(lightmapX, lightmapY).func_181675_d();
            buffer.func_228462_a_(type);
        }
        matrix.func_227861_a_(0.0, Math.sin(EffectUtil.toRad(te.getCringangle())) / 2.0 * (double)te.getHeight(), 0.0);
        loadImage = te.getRunes();
        if (te.getShowRing()) {
            if (loadImage >= 0) {
                for (int j = 0; j < MTConfig.MAGIC_RUNES.size(); ++j) {
                    ClientImageDownloadUtil.download("runes" + j, MTConfig.MAGIC_RUNES.get(j), true);
                }
                if (loadImage < ClientImageDownloadUtil.lstRunes.size()) {
                    try {
                        type = MahoujinRenderType.createRunesRenderType(ClientImageDownloadUtil.lstRunes.get(loadImage), rindex++);
                    }
                    catch (Exception e) {
                        type = MahoujinRenderType.createRunesRenderType(RenderUtils.runes, rindex++);
                    }
                } else {
                    type = MahoujinRenderType.createRunesRenderType(RenderUtils.runes, rindex++);
                }
            } else {
                type = MahoujinRenderType.createRunesRenderType(RenderUtils.runes, rindex++);
            }
            MahoujinProjectorRenderer.renderRing(positionMatrix, 0.0, ring, size / 2.0f + 0.125f, te.getHeight(), 128, (IRenderTypeBuffer)buffer, lightmapX, lightmapY, r, g, b, a, type);
            buffer.func_228462_a_(type);
        }
        matrix.func_227865_b_();
    }
}

