/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.util.Utils;

public class SavePagePacket {
    int page;

    public SavePagePacket() {
    }

    public SavePagePacket(int page) {
        this.page = page;
    }

    public void fromBytes(ByteBuf buf) {
        this.page = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.page);
    }

    public static void encode(SavePagePacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static SavePagePacket decode(PacketBuffer buf) {
        SavePagePacket msg = new SavePagePacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(SavePagePacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            IMahou mahou = Utils.getPlayerMahou((PlayerEntity)player);
            if (mahou != null) {
                mahou.setGuidePage(message.page);
            }
            PlayerManaManager.updateClientMahou(player, mahou);
        });
        context.get().setPacketHandled(true);
    }
}

