/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class FogPacket {
    public int eid = 0;
    public double range = 0.0;
    public double space = 0.0;

    public FogPacket() {
    }

    public FogPacket(int eid, double range, double space) {
        this.eid = eid;
        this.range = range;
        this.space = space;
    }

    public void fromBytes(ByteBuf buf) {
        this.eid = buf.readInt();
        this.range = buf.readDouble();
        this.space = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.eid);
        buf.writeDouble(this.range);
        buf.writeDouble(this.space);
    }

    public static void encode(FogPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static FogPacket decode(PacketBuffer buf) {
        FogPacket msg = new FogPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(FogPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.fog(message);
        context.get().setPacketHandled(true);
    }
}

