/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class FaeNoisePacket {
    float vol;
    float pit;
    int x;
    int y;
    int z;
    SoundEvent sound;
    SoundCategory cat;

    public FaeNoisePacket() {
    }

    public FaeNoisePacket(int x, int y, int z, SoundEvent sound, SoundCategory cat, float vol, float pit) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.sound = sound;
        this.cat = cat;
        this.vol = vol;
        this.pit = pit;
    }

    public void fromBytes(ByteBuf buf) {
        this.sound = (SoundEvent)Registry.field_212633_v.func_148745_a(buf.readInt());
        this.cat = this.readEnumValue(SoundCategory.class, buf);
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.vol = buf.readFloat();
        this.pit = buf.readFloat();
    }

    public <T extends Enum<T>> T readEnumValue(Class<T> enumClass, ByteBuf buf) {
        return (T)((Enum[])enumClass.getEnumConstants())[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(Registry.field_212633_v.func_148757_b((Object)this.sound));
        buf.writeInt(this.cat.ordinal());
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeFloat(this.vol);
        buf.writeFloat(this.pit);
    }

    public static void encode(FaeNoisePacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static FaeNoisePacket decode(PacketBuffer buf) {
        FaeNoisePacket msg = new FaeNoisePacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(FaeNoisePacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.faeNoiseHandler(message);
        context.get().setPacketHandled(true);
    }
}

