/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.lance;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.jousting.item.ItemLance;
import stepsword.mahoutsukai.capability.lance.ILanceMahou;
import stepsword.mahoutsukai.capability.lance.LanceMahou;
import stepsword.mahoutsukai.capability.lance.LanceMahouProvider;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.entity.mahoujin.RhongomyniadEntity;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.render.item.RhongomyniadRenderer;
import stepsword.mahoutsukai.util.FakeSkeleton;
import stepsword.mahoutsukai.util.Utils;

public class Rhongomyniad
extends ItemLance {
    public static final UUID speedlance = UUID.fromString("91AEAA56-377B-4498-936B-2E8F20090635");
    public static final String MT_ATTACK_DAMAGE = "mahoutsukai_rhongomyniad_attack";
    public static final String MT_WEIGHT = "mahoutsukai_rhongomyniad_weight";

    public Rhongomyniad() {
        super("rhongomyniad", ModItems.MAHOUTSUKAI_CREATIVE_TAB, () -> 1200, () -> 10.0, () -> 2.0, () -> RhongomyniadRenderer::new);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new LanceMahouProvider();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        if (player.func_226273_bm_() && handIn == Hand.MAIN_HAND && !worldIn.field_72995_K) {
            BlockRayTraceResult result = Rhongomyniad.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
            if (result != null && result.func_216350_a() != null) {
                ItemStack r = player.func_184614_ca().func_77946_l();
                RhongomyniadEntity rhongomyniad = new RhongomyniadEntity(worldIn, player, 1.0f, r);
                BlockPos p = result.func_216350_a().func_177972_a(result.func_216354_b());
                rhongomyniad.func_70107_b((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5);
                worldIn.func_217376_c((Entity)rhongomyniad);
                player.func_184614_ca().func_190918_g(1);
            }
            return ActionResult.func_226248_a_((Object)player.func_184614_ca());
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (stack.func_77973_b() instanceof Rhongomyniad && player.func_184187_bx() != null && player.func_184187_bx() instanceof LivingEntity) {
            LivingEntity riding = (LivingEntity)player.func_184187_bx();
            if (!player.field_70170_p.func_175647_a(LivingEntity.class, player.func_174813_aQ().func_186662_g((double)MTConfig.RHONGOMYNIAD_RANGE), b -> Caliburn.specialTarget(b)).isEmpty()) {
                Rhongomyniad.addspeed(riding, true);
            }
        }
        super.onUsingTick(stack, player, count);
    }

    public static float simulateHit(ItemStack s, World world) {
        float ret = 3.0f;
        int health = 5000000;
        if (s != null) {
            ItemStack s1 = s.func_77946_l();
            FakeSkeleton fake_target = new FakeSkeleton(world);
            fake_target.h = 5000000.0f;
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerWorld)world, new GameProfile(UUID.randomUUID(), "faker"));
            fake_player.func_184611_a(Hand.MAIN_HAND, s1);
            fake_player.func_233645_dx_().func_233793_b_(s1.func_111283_C(EquipmentSlotType.MAINHAND));
            ((PlayerEntity)fake_player).field_184617_aD = 1000;
            if (s1.func_77973_b() instanceof ItemLance) {
                ((ItemLance)s1.func_77973_b()).attackTargetEntityWithCurrentItem((Entity)fake_target, (PlayerEntity)fake_player);
            }
            ret = (float)health - fake_target.h;
        }
        return ret;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity player, int timeLeft) {
        if (player.func_184187_bx() instanceof LivingEntity) {
            Rhongomyniad.addspeed((LivingEntity)player.func_184187_bx(), false);
        }
        super.func_77615_a(stack, worldIn, player, timeLeft);
    }

    public static void addspeed(LivingEntity living, boolean add) {
        AttributeModifier a = new AttributeModifier(speedlance, "rhongomyniad_speed", MTConfig.RHONGOMYNIAD_SPEED_FACTOR, AttributeModifier.Operation.MULTIPLY_TOTAL);
        ModifiableAttributeInstance attr = living.func_110148_a(Attributes.field_233821_d_);
        if (attr != null) {
            boolean hasSpeed = attr.func_180374_a(a);
            if (add) {
                if (!hasSpeed) {
                    attr.func_233767_b_(a);
                }
            } else if (hasSpeed) {
                attr.func_111124_b(a);
            }
        }
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        if (ret == null) {
            ILanceMahou mahou = Utils.getLanceMahou(stack);
            return (CompoundNBT)LanceMahouProvider.MAHOU.getStorage().writeNBT(LanceMahouProvider.MAHOU, (Object)mahou, null);
        }
        return ret;
    }

    public static void setattacktonbt(ItemStack stack, World world) {
        if (stack != null && !world.field_72995_K) {
            ILanceMahou mahou;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if ((mahou = Utils.getLanceMahou(stack)) != null) {
                nbt.func_74776_a(MT_ATTACK_DAMAGE, mahou.getAttackDamage());
                nbt.func_74776_a(MT_WEIGHT, mahou.getWeight());
            }
            stack.func_77982_d(nbt);
        }
    }

    public static void getattackfromnbt(ItemStack stack) {
        if (stack != null && stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            ILanceMahou mahou = Utils.getLanceMahou(stack);
            if (mahou != null) {
                if (nbt != null && nbt.func_74764_b(MT_ATTACK_DAMAGE)) {
                    mahou.setAttackDamage(Math.max(nbt.func_74760_g(MT_ATTACK_DAMAGE), mahou.getAttackDamage()));
                }
                if (nbt != null && nbt.func_74764_b(MT_WEIGHT)) {
                    mahou.setWeight(Math.max(nbt.func_74760_g(MT_WEIGHT), mahou.getWeight()));
                }
            }
        }
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbtt) {
        if (nbtt != null) {
            ILanceMahou lanceMahou = Utils.getLanceMahou(stack);
            LanceMahou serverLanceMahou = new LanceMahou();
            LanceMahouProvider.MAHOU.getStorage().readNBT(LanceMahouProvider.MAHOU, (Object)serverLanceMahou, null, (INBT)nbtt);
            if (lanceMahou != null) {
                lanceMahou.setAttackDamage(serverLanceMahou.getAttackDamage());
                lanceMahou.setWeight(serverLanceMahou.getWeight());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public double getAttackDamage(ItemStack stack) {
        ILanceMahou mahou;
        Rhongomyniad.getattackfromnbt(stack);
        double damage = 1.0;
        if (stack != null && (mahou = Utils.getLanceMahou(stack)) != null) {
            damage += (double)mahou.getAttackDamage();
        }
        return damage;
    }

    public double getWeight(ItemStack stack) {
        ILanceMahou mahou;
        Rhongomyniad.getattackfromnbt(stack);
        double weight = 2.0;
        if (stack != null && (mahou = Utils.getLanceMahou(stack)) != null) {
            weight = mahou.getWeight();
        }
        return weight;
    }
}

