/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;

public class MahouLightningBoltEntity
extends Entity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private final boolean effectOnly;
    @Nullable
    private ServerPlayerEntity caster;
    public static final String entityName = "sky_lightning_bolt_entity";

    public MahouLightningBoltEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
        this.field_70158_ak = true;
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.effectOnly = true;
        Difficulty difficulty = world.func_175659_aa();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public MahouLightningBoltEntity(World world) {
        super(ModEntities.LIGHTNING_BOLT, world);
        this.field_70158_ak = true;
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.effectOnly = true;
        Difficulty difficulty = world.func_175659_aa();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public MahouLightningBoltEntity(World worldIn, double x, double y, double z, boolean effectOnlyIn) {
        super(ModEntities.LIGHTNING_BOLT, worldIn);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.effectOnly = effectOnlyIn;
        Difficulty difficulty = worldIn.func_175659_aa();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void setCaster(@Nullable ServerPlayerEntity casterIn) {
        this.caster = casterIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lightningState == 2) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.field_70146_Z.nextLong();
                this.igniteBlocks(0);
            }
        }
        if (this.lightningState >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_225605_c_(2);
            } else if (!this.effectOnly) {
                double d0 = 3.0;
                List list = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - 3.0, this.func_226278_cu_() - 3.0, this.func_226281_cx_() - 3.0, this.func_226277_ct_() + 3.0, this.func_226278_cu_() + 6.0 + 3.0, this.func_226281_cx_() + 3.0), Entity::func_70089_S);
                for (Entity entity : list) {
                    LightningBoltEntity fake = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
                    if (fake == null) continue;
                    fake.func_233576_c_(new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
                    fake.func_233623_a_(false);
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBoltEntity)fake)) continue;
                    entity.func_241841_a((ServerWorld)this.field_70170_p, fake);
                    entity.field_190534_ay = 0;
                }
                if (this.caster != null) {
                    CriteriaTriggers.field_204812_E.func_204814_a(this.caster, (Collection)list);
                }
            }
        }
    }

    private void igniteBlocks(int extraIgnitions) {
        if (MTConfig.EMRYS_BOLT_FIRE && !this.effectOnly && !this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            BlockState blockstate = Blocks.field_150480_ab.func_176223_P();
            BlockPos blockpos = new BlockPos(this.func_213303_ch());
            if (this.field_70170_p.func_180495_p(blockpos).func_196958_f() && blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175656_a(blockpos, blockstate);
            }
            for (int i = 0; i < extraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (!this.field_70170_p.func_180495_p(blockpos1).func_196958_f() || !blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos1)) continue;
                this.field_70170_p.func_175656_a(blockpos1, blockstate);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * MahouLightningBoltEntity.func_184183_bd();
        return distance < d0 * d0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

