/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.secret;

import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.util.Utils;

public class GeasEffect {
    public static String BREAK = "==MAHOU==";

    public static boolean geasEffect(PlayerEntity caster) {
        Entity e = ProjectionSpellEffect.playerLook((LivingEntity)caster, 12.0, caster.field_70170_p, ProjectionSpellEffect.getProjectionLookPredicate(), 0.5f);
        if (e instanceof LivingEntity) {
            return GeasEffect.addGeas(caster, (LivingEntity)e);
        }
        if (e instanceof ItemEntity) {
            return GeasEffect.addGeas(caster, (ItemEntity)e);
        }
        TranslationTextComponent tt = new TranslationTextComponent("mahoutsukai.geas.geasa");
        tt.func_230529_a_((ITextComponent)new StringTextComponent(" " + GeasEffect.getGeasString(caster)));
        if (caster instanceof ServerPlayerEntity) {
            caster.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + tt.getString()), false);
        }
        return false;
    }

    public static boolean geasItem(EntityItemPickupEvent event) {
        return GeasEffect.hasGeas(event.getPlayer(), event.getItem().func_92059_d());
    }

    public static boolean geasLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        Entity e = event.getSource().func_76346_g();
        if (e instanceof PlayerEntity) {
            return GeasEffect.hasGeas((PlayerEntity)e, target);
        }
        return false;
    }

    public static boolean geasAttackEntity(AttackEntityEvent event) {
        Entity target = event.getTarget();
        Entity e = event.getEntity();
        if (e instanceof PlayerEntity && target instanceof LivingEntity && GeasEffect.hasGeas((PlayerEntity)e, (LivingEntity)target)) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public static boolean addGeas(PlayerEntity player, LivingEntity target) {
        String message;
        String geas;
        boolean r = true;
        if (target instanceof PlayerEntity) {
            geas = target.func_145748_c_().getString() + BREAK + "minecraft:player";
            message = target.func_145748_c_().getString();
        } else {
            geas = target.func_200600_R().getRegistryName().toString();
            message = target.func_145748_c_().getString();
            if (target.func_200201_e() != null && !player.func_226273_bm_()) {
                message = target.func_200201_e().getString();
                geas = target.func_200201_e().getString() + BREAK + geas;
            }
        }
        r = GeasEffect.add(player, message, TextFormatting.func_110646_a((String)geas));
        return r;
    }

    public static boolean add(PlayerEntity player, String message, String geas) {
        boolean r = true;
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            String added = "mahoutsukai.geas.added";
            if (geasList.contains(geas)) {
                added = "mahoutsukai.geas.removed";
                geasList.remove(geas);
                r = false;
            } else {
                geasList.add(geas);
            }
            TranslationTextComponent tt = new TranslationTextComponent(added);
            tt.func_230529_a_((ITextComponent)new StringTextComponent(" " + message));
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).func_146105_b((ITextComponent)tt, true);
            }
        }
        return r;
    }

    public static boolean addGeas(PlayerEntity player, ItemEntity item) {
        boolean r = true;
        String s = "Item:" + item.func_92059_d().func_77973_b().func_200295_i(item.func_92059_d()).getString();
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            r = GeasEffect.add(player, s, TextFormatting.func_110646_a((String)s));
        }
        return r;
    }

    public static boolean hasGeas(PlayerEntity player, ItemStack item) {
        String s = "Item:" + item.func_77973_b().func_200295_i(item).getString();
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                if (!g.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGeas(PlayerEntity player, LivingEntity target) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            String nameDisplay = "";
            if (target.func_200201_e() != null) {
                nameDisplay = target.func_200201_e().getString();
            }
            if (target instanceof PlayerEntity) {
                nameDisplay = target.func_145748_c_().getString();
            }
            String nameType = target.func_200600_R().getRegistryName().toString();
            for (String g : geasList) {
                String[] lst;
                if (!(g.contains(BREAK) ? (lst = g.split(BREAK)).length >= 2 && lst[0].equals(nameDisplay) && lst[1].equals(nameType) : nameType.equals(g))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getGeasString(PlayerEntity player) {
        String geasa = "";
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                String[] lst = g.split(BREAK);
                if (!geasa.equals("")) {
                    geasa = geasa + ", ";
                }
                if (lst.length > 1) {
                    geasa = geasa + GeasEffect.regToName(lst[1]);
                    geasa = geasa + " - " + lst[0];
                    continue;
                }
                geasa = geasa + GeasEffect.regToName(lst[0]);
            }
        }
        return geasa;
    }

    public static int getUniqueGeasCount(PlayerEntity player) {
        int geasa = 0;
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                String[] lst = g.split(BREAK);
                if (lst.length != 1 || lst[0].startsWith("Item:")) continue;
                ++geasa;
            }
        }
        return geasa;
    }

    public static String regToName(String res) {
        if (!res.startsWith("Item:")) {
            ResourceLocation loc = new ResourceLocation(res);
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(loc);
            if (type != null) {
                return type.func_212546_e().getString();
            }
            return res;
        }
        return res;
    }
}

