/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.dimension;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import stepsword.mahoutsukai.dimension.NoiseGeneratorOctaves;
import stepsword.mahoutsukai.dimension.NoiseGeneratorPerlin;

public class RealityMarbleTerrainGenerator
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private Random random;
    private final double[] heightMap;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves depthNoise;
    private final float[] biomeWeights;
    private double[] depthBuffer = new double[256];
    private Biome[] biomesForGeneration;
    long seed = 12341253L;

    public RealityMarbleTerrainGenerator(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
        this.setRegistryName("mahoutsukai:reality_marble");
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public void func_205548_a(long seed) {
        this.seed = seed;
    }

    public void setBiomesForGeneration(Biome[] biomesForGeneration) {
        this.biomesForGeneration = biomesForGeneration;
    }

    public void setup() {
        this.random = new Random((this.seed + 516L) * 314L);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.random, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.random, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.random, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.random, 4);
        NoiseGeneratorOctaves noiseGen5 = new NoiseGeneratorOctaves(this.random, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.random, 16);
    }

    private void generateHeightmap(int chunkX4, int chunkY4, int chunkZ4) {
        this.depthRegion = this.depthNoise.generateNoiseOctaves(this.depthRegion, chunkX4, chunkZ4, 5, 5, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.generateNoiseOctaves(this.mainNoiseRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 8.55515, 4.277575, 8.55515);
        this.minLimitRegion = this.minLimitPerlinNoise.generateNoiseOctaves(this.minLimitRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 684.412, 684.412, 684.412);
        this.maxLimitRegion = this.maxLimitPerlinNoise.generateNoiseOctaves(this.maxLimitRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 684.412, 684.412, 684.412);
        int l = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < 5; ++j1) {
            for (int k1 = 0; k1 < 5; ++k1) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        Biome biome = this.biomesForGeneration[0];
                        float baseHeight = biome.func_185355_j();
                        float variation = biome.func_185360_m();
                        float f5 = this.biomeWeights[l1 + 2 + (i2 + 2) * 5] / (baseHeight + 2.0f);
                        f += variation * f5;
                        f1 += baseHeight * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.depthRegion[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = f;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[l] / 512.0;
                    double d8 = this.maxLimitRegion[l] / 512.0;
                    double d9 = (this.mainNoiseRegion[l] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151237_a((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[l] = d10;
                    ++l;
                }
            }
        }
    }

    public void generate(int chunkX, int chunkZ, IChunk primer) {
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        boolean waterLevel = false;
        for (int x4 = 0; x4 < 4; ++x4) {
            int l = x4 * 5;
            int i1 = (x4 + 1) * 5;
            for (int z4 = 0; z4 < 4; ++z4) {
                int k1 = (l + z4) * 33;
                int l1 = (l + z4 + 1) * 33;
                int i2 = (i1 + z4) * 33;
                int j2 = (i1 + z4 + 1) * 33;
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[k1 + height32];
                    double d2 = this.heightMap[l1 + height32];
                    double d3 = this.heightMap[i2 + height32];
                    double d4 = this.heightMap[j2 + height32];
                    double d5 = (this.heightMap[k1 + height32 + 1] - d1) * d0;
                    double d6 = (this.heightMap[l1 + height32 + 1] - d2) * d0;
                    double d7 = (this.heightMap[i2 + height32 + 1] - d3) * d0;
                    double d8 = (this.heightMap[j2 + height32 + 1] - d4) * d0;
                    for (int h = 0; h < 8; ++h) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int height = height32 * 8 + h;
                        for (int x = 0; x < 4; ++x) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                double d;
                                if (height < 2) {
                                    primer.func_177436_a(new BlockPos(x4 * 4 + x, height32 * 8 + h, z4 * 4 + z), Blocks.field_150357_h.func_176223_P(), false);
                                    continue;
                                }
                                d15 += d16;
                                if (!(d > 0.0)) continue;
                                primer.func_177436_a(new BlockPos(x4 * 4 + x, height32 * 8 + h, z4 * 4 + z), Blocks.field_180395_cM.func_176223_P(), false);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, IChunk primer, Biome[] biomes, IWorld world) {
    }

    public void apply(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.generate(x, z, chunkIn);
    }
}

