/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;

public class PowerMonitorTileEntity
extends LogicTileEntity
implements ITickableTileEntity {
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Power Monitor").containerSupplier(DefaultContainerProvider.empty(MonitorModule.CONTAINER_POWER_MONITOR, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));
    public static final IntegerProperty LEVEL = IntegerProperty.func_177719_a((String)"level", (int)0, (int)5);
    @GuiValue
    private int minimum;
    @GuiValue
    private int maximum;
    private int rflevel = 0;
    private boolean inAlarm = false;
    private int counter = 20;

    public PowerMonitorTileEntity() {
        super((TileEntityType)MonitorModule.TYPE_POWER_MONITOR.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powermonitor/powermonitor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PowerMonitorTileEntity::new)){

            protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new Property[]{LEVEL});
            }
        };
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.func_70296_d();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.func_70296_d();
    }

    public void setInvalid() {
        this.changeRfLevel(0);
        this.setRedstoneState(0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        Direction inputSide = this.getFacing(this.field_145850_b.func_180495_p(this.func_174877_v())).getInputSide();
        BlockPos inputPos = this.func_174877_v().func_177972_a(inputSide);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(inputPos);
        if (!EnergyTools.isEnergyTE((TileEntity)tileEntity, null)) {
            this.setInvalid();
            return;
        }
        EnergyTools.EnergyLevel energy = EnergyTools.getEnergyLevelMulti((TileEntity)tileEntity, null);
        long maxEnergy = energy.getMaxEnergy();
        int ratio = 0;
        boolean alarm = false;
        if (maxEnergy > 0L) {
            long stored = energy.getEnergy();
            ratio = (int)(1L + stored * 5L / maxEnergy);
            if (ratio < 1) {
                ratio = 1;
            } else if (ratio > 5) {
                ratio = 5;
            }
            long percentage = stored * 100L / maxEnergy;
            boolean bl = alarm = percentage >= (long)this.minimum && percentage <= (long)this.maximum;
        }
        if (this.rflevel != ratio) {
            this.changeRfLevel(ratio);
            this.func_70296_d();
        }
        if (alarm != this.inAlarm) {
            this.inAlarm = alarm;
            this.setRedstoneState(this.inAlarm ? 15 : 0);
            this.func_70296_d();
        }
    }

    private void changeRfLevel(int newRfLevel) {
        if (newRfLevel != this.rflevel) {
            this.rflevel = newRfLevel;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(this.rflevel)), 11);
            this.func_70296_d();
        }
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.inAlarm = tagCompound.func_74767_n("inAlarm");
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.rflevel = info.func_74762_e("rflevel");
        this.minimum = info.func_74771_c("minimum");
        this.maximum = info.func_74771_c("maximum");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("inAlarm", this.inAlarm);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("rflevel", this.rflevel);
        info.func_74774_a("minimum", (byte)this.minimum);
        info.func_74774_a("maximum", (byte)this.maximum);
    }
}

