/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import java.util.HashSet;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class PearlInjectorTileEntity
extends GenericTileEntity
implements ITickableTileEntity,
TickOrderHandler.IOrderTicker {
    public static final int BUFFER_SIZE = 18;
    public static final int SLOT_BUFFER = 0;
    public static final int SLOT_PLAYERINV = 18;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(18).box(SlotDefinition.specific((Item[])new Item[]{Items.field_151079_bi}).in(), 0, 10, 25, 9, 2).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.match((Item)Items.field_151079_bi)).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Pearl Injector").containerSupplier(DefaultContainerProvider.container(EndergenicModule.CONTAINER_PEARL_INJECTOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private boolean prevIn = false;

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/pearlinjector")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PearlInjectorTileEntity::new));
    }

    public PearlInjectorTileEntity() {
        super((TileEntityType)EndergenicModule.TYPE_PEARL_INJECTOR.get());
    }

    public EndergenicTileEntity findEndergenicTileEntity() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        Direction k = OrientationTools.getOrientation((BlockState)state);
        EndergenicTileEntity te = this.getEndergenicGeneratorAt(k.func_176734_d());
        if (te != null) {
            return te;
        }
        return this.getEndergenicGeneratorAt(Direction.UP);
    }

    private EndergenicTileEntity getEndergenicGeneratorAt(Direction k) {
        BlockPos o = this.func_174877_v().func_177972_a(k);
        TileEntity te = this.field_145850_b.func_175625_s(o);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            long ticker = TickOrderHandler.getTicker();
            TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
            HashSet<BlockPos> connectedEndergenics = new HashSet<BlockPos>();
            for (EndergenicTileEntity endergenic = this.findEndergenicTileEntity(); endergenic != null && !connectedEndergenics.contains(endergenic.func_174877_v()); endergenic = endergenic.getDestinationTE()) {
                if (ticker != endergenic.getTicker()) {
                    endergenic.setTicker(ticker);
                    TickOrderHandler.queue((TickOrderHandler.IOrderTicker)endergenic);
                }
                connectedEndergenics.add(endergenic.func_174877_v());
            }
        }
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_0;
    }

    public void tickServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        if (this.prevIn == this.powerLevel > 0) {
            return;
        }
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.injectPearl();
        }
        this.func_70296_d();
    }

    private boolean takePearl() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.func_190926_b() || !Items.field_151079_bi.equals(stack.func_77973_b()) || stack.func_190916_E() <= 0) continue;
            this.items.decrStackSize(i, 1);
            return true;
        }
        return false;
    }

    public void injectPearl() {
        EndergenicTileEntity endergen = this.findEndergenicTileEntity();
        if (endergen != null) {
            if (!this.takePearl()) {
                return;
            }
            int mode = endergen.getChargingMode();
            if (mode != -1) {
                endergen.firePearlFromInjector();
            }
        }
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        return tagCompound;
    }
}

