/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.data.EnderMonitorMode;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;

public class EnderMonitorTileEntity
extends LogicTileEntity
implements ITickableTileEntity,
TickOrderHandler.IOrderTicker {
    @GuiValue
    private EnderMonitorMode mode = EnderMonitorMode.MODE_LOSTPEARL;
    private boolean needpulse = false;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Ender Monitor").containerSupplier(DefaultContainerProvider.empty(EndergenicModule.CONTAINER_ENDER_MONITOR, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/endergenic")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(EnderMonitorTileEntity::new));
    }

    public EnderMonitorTileEntity() {
        super((TileEntityType)EndergenicModule.TYPE_ENDER_MONITOR.get());
    }

    public EnderMonitorMode getMode() {
        return this.mode;
    }

    public void setMode(EnderMonitorMode mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    public void fireFromEndergenic(EnderMonitorMode mode) {
        if (this.mode != mode) {
            return;
        }
        this.needpulse = true;
        this.markDirtyQuick();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
        }
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_2;
    }

    public void tickServer() {
        int newout = 0;
        if (this.needpulse) {
            this.markDirtyQuick();
            newout = 15;
            this.needpulse = false;
        }
        this.setRedstoneState(newout);
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.needpulse = tagCompound.func_74767_n("needPulse");
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        int m = info.func_74762_e("mode");
        this.mode = EnderMonitorMode.values()[m];
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("needPulse", this.needpulse);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        this.getOrCreateInfo(tagCompound).func_74768_a("mode", this.mode.ordinal());
    }
}

