/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class BlazingGeneratorTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final int BUFFER_SIZE = 4;
    public static final BooleanProperty WORKING = BooleanProperty.func_177716_a((String)"working");
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(4).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).in(), 0, 10, 7).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).in(), 1, 82, 7).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).in(), 2, 10, 43).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).in(), 3, 82, 43).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid(GenericItemHandler.match(BlazingModule.BLAZING_ROD)).onUpdate((slot, stack) -> this.updateSlot((int)slot)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)BlazingConfiguration.GENERATOR_MAXENERGY.get()).intValue(), 0L);
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    private int[] rfPerTickMax = new int[4];
    private float[] rfPerTick = new float[4];
    private int[] ticksRemaining = new int[4];
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Blazing Generator").containerSupplier(DefaultContainerProvider.container(BlazingModule.CONTAINER_BLAZING_GENERATOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).shortListener(Sync.integer(() -> (int)this.rfPerTick[0], v -> {
        this.rfPerTick[0] = v.intValue();
    })).shortListener(Sync.integer(() -> (int)this.rfPerTick[1], v1 -> {
        this.rfPerTick[1] = v1.intValue();
    })).shortListener(Sync.integer(() -> (int)this.rfPerTick[2], v2 -> {
        this.rfPerTick[2] = v2.intValue();
    })).shortListener(Sync.integer(() -> (int)this.rfPerTick[3], v3 -> {
        this.rfPerTick[3] = v3.intValue();
    })).setupSync((GenericTileEntity)this));

    public BlazingGeneratorTileEntity() {
        super((TileEntityType)BlazingModule.TYPE_BLAZING_GENERATOR.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/blazinggenerator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(BlazingGeneratorTileEntity::new)){

            protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new Property[]{WORKING});
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.handleSendingEnergy();
            this.handlePowerGeneration();
        }
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            super.setPowerInput(powered);
            for (int i = 0; i < 4; ++i) {
                this.updateSlot(i);
            }
        }
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        super.setRSMode(redstoneMode);
        for (int i = 0; i < 4; ++i) {
            this.updateSlot(i);
        }
    }

    public float getRfPerTick(int slot) {
        return this.rfPerTick[slot];
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy();
        EnergyTools.handleSendingEnergy((World)this.field_145850_b, (BlockPos)this.field_174879_c, (long)storedPower, (long)((Integer)BlazingConfiguration.GENERATOR_SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    private void handlePowerGeneration() {
        int totalRfGenerated = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.rfPerTick[i] > (float)this.rfPerTickMax[i]) {
                int n = i;
                this.rfPerTick[n] = this.rfPerTick[n] + ((float)this.rfPerTickMax[i] - this.rfPerTick[i]) / 30.0f;
                if (this.rfPerTick[i] < (float)this.rfPerTickMax[i]) {
                    this.rfPerTick[i] = this.rfPerTickMax[i];
                }
            } else if (this.rfPerTick[i] < (float)this.rfPerTickMax[i]) {
                int n = i;
                this.rfPerTick[n] = this.rfPerTick[n] + (((float)this.rfPerTickMax[i] - this.rfPerTick[i]) / 150.0f + 0.01f);
                if (this.rfPerTick[i] > (float)this.rfPerTickMax[i]) {
                    this.rfPerTick[i] = this.rfPerTickMax[i];
                }
            }
            totalRfGenerated += (int)this.rfPerTick[i];
            if (!this.isMachineEnabled()) continue;
            int n = i;
            this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
            ItemStack stack = this.items.getStackInSlot(i);
            if (this.ticksRemaining[i] <= 0) {
                this.ticksRemaining[i] = 0;
                this.rfPerTickMax[i] = 0;
                if (stack.func_190926_b()) continue;
                this.items.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            if (stack.func_190926_b()) continue;
            BlazingRod.setPowerDuration(stack, this.ticksRemaining[i]);
        }
        this.energyStorage.produceEnergy((long)totalRfGenerated);
        boolean generating = totalRfGenerated > 0;
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if ((Boolean)state.func_177229_b((Property)WORKING) != generating) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)WORKING, (Comparable)Boolean.valueOf(generating)), 3);
        }
        this.markDirtyQuick();
    }

    private void updateSlot(int slot) {
        ItemStack stack = this.items.getStackInSlot(slot);
        if (stack.func_190926_b() || !this.isMachineEnabled()) {
            this.rfPerTickMax[slot] = 0;
            this.ticksRemaining[slot] = 0;
        } else {
            this.rfPerTickMax[slot] = (int)((float)BlazingRod.getRfPerTick(stack) * (this.infusable.getInfusedFactor() * 0.1f + 1.0f));
            this.ticksRemaining[slot] = BlazingRod.getTotalTicks(stack);
        }
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        for (int i = 0; i < 4; ++i) {
            this.rfPerTickMax[i] = tagCompound.func_74762_e("rftMax" + i);
            this.rfPerTick[i] = tagCompound.func_74760_g("rft" + i);
            this.ticksRemaining[i] = tagCompound.func_74762_e("ticks" + i);
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        for (int i = 0; i < 4; ++i) {
            tagCompound.func_74768_a("rftMax" + i, this.rfPerTickMax[i]);
            tagCompound.func_74776_a("rft" + i, this.rfPerTick[i]);
            tagCompound.func_74768_a("ticks" + i, this.ticksRemaining[i]);
        }
        return super.func_189515_b(tagCompound);
    }
}

