/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.client.renderer;

import com.girafi.waddles.client.model.PenguinModel;
import com.girafi.waddles.entity.AdeliePenguinEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PenguinRenderer
extends MobRenderer<AdeliePenguinEntity, PenguinModel<AdeliePenguinEntity>> {
    public PenguinRenderer(EntityRendererManager renderManager) {
        super(renderManager, new PenguinModel(), 0.5f);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AdeliePenguinEntity penguin) {
        String name = penguin.func_200200_C_().getString().toLowerCase().trim();
        if (name.equals("joshie") || name.equals("joshiejack")) {
            return this.getPenguinTexture("joshie");
        }
        if (name.equals("darkosto")) {
            return this.getPenguinTexture("darkosto");
        }
        return penguin.func_70631_g_() ? this.getPenguinTexture("adelie_child") : this.getPenguinTexture("adelie");
    }

    private ResourceLocation getPenguinTexture(String fileName) {
        return new ResourceLocation("waddles", "textures/entity/penguin/" + fileName + ".png");
    }
}

