/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.structure;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFRotation;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnion;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFCappedCone;
import mod.beethoven92.betterendforge.common.world.structure.SDFStructure;
import mod.beethoven92.betterendforge.common.world.structure.StructureWorld;
import mod.beethoven92.betterendforge.common.world.structure.piece.VoxelPiece;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class GiantIceStarStructure
extends SDFStructure {
    private final float minSize = 20.0f;
    private final float maxSize = 35.0f;
    private final int minCount = 25;
    private final int maxCount = 40;

    public GiantIceStarStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public String func_143025_a() {
        return "betterendforge:giant_ice_star_structure";
    }

    @Override
    protected SDF getSDF(BlockPos pos, Random random) {
        float size = ModMathHelper.randRange(20.0f, 35.0f, random);
        int count = ModMathHelper.randRange(25, 40, random);
        List<Vector3f> points = this.getFibonacciPoints(count);
        SDF sdf = null;
        SDF spike = new SDFCappedCone().setRadius1(3.0f + (size - 5.0f) * 0.2f).setRadius2(0.0f).setHeight(size).setBlock((Block)ModBlocks.DENSE_SNOW.get());
        spike = new SDFTranslate().setTranslate(0.0f, size - 0.5f, 0.0f).setSource(spike);
        for (Vector3f point : points) {
            SDF rotated = spike;
            float angle = ModMathHelper.angle(Vector3f.field_229181_d_, point = ModMathHelper.normalize(point));
            if (angle > 0.01f && angle < 3.14f) {
                Vector3f axis = ModMathHelper.normalize(ModMathHelper.cross(Vector3f.field_229181_d_, point));
                rotated = new SDFRotation().setRotation(axis, angle).setSource(spike);
            } else if (angle > 1.0f) {
                rotated = new SDFRotation().setRotation(Vector3f.field_229181_d_, (float)Math.PI).setSource(spike);
            }
            sdf = sdf == null ? rotated : new SDFUnion().setSourceA(sdf).setSourceB(rotated);
        }
        float ancientRadius = size * 0.7f;
        float denseRadius = size * 0.9f;
        float iceRadius = size < 7.0f ? size * 5.0f : size * 1.3f;
        float randScale = size * 0.3f;
        BlockPos center = pos;
        BlockState ice = ((Block)ModBlocks.EMERALD_ICE.get()).func_176223_P();
        BlockState dense = ((Block)ModBlocks.DENSE_EMERALD_ICE.get()).func_176223_P();
        BlockState ancient = ((Block)ModBlocks.ANCIENT_EMERALD_ICE.get()).func_176223_P();
        SDF sdfCopy = sdf;
        return sdf.addPostProcess(info -> {
            float pz;
            float py;
            BlockPos bpos = info.getPos();
            float px = bpos.func_177958_n() - center.func_177958_n();
            float distance = ModMathHelper.length(px, py = (float)(bpos.func_177956_o() - center.func_177956_o()), pz = (float)(bpos.func_177952_p() - center.func_177952_p())) + sdfCopy.getDistance(px, py, pz) * 0.4f + random.nextFloat() * randScale;
            if (distance < ancientRadius) {
                return ancient;
            }
            if (distance < denseRadius) {
                return dense;
            }
            if (distance < iceRadius) {
                return ice;
            }
            return info.getState();
        });
    }

    private List<Vector3f> getFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(count);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = ModMathHelper.PHI * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new Vector3f(x, y, z));
        }
        return result;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> p_i225876_1_, int p_i225876_2_, int p_i225876_3_, MutableBoundingBox p_i225876_4_, int p_i225876_5_, long p_i225876_6_) {
            super(p_i225876_1_, p_i225876_2_, p_i225876_3_, p_i225876_4_, p_i225876_5_, p_i225876_6_);
        }

        public void func_230364_a_(DynamicRegistries registry, ChunkGenerator chunkGenerator, TemplateManager manager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int x = chunkX << 4 | ModMathHelper.randRange(4, 12, (Random)this.field_214631_d);
            int z = chunkZ << 4 | ModMathHelper.randRange(4, 12, (Random)this.field_214631_d);
            BlockPos start = new BlockPos(x, ModMathHelper.randRange(32, 128, (Random)this.field_214631_d), z);
            VoxelPiece piece = new VoxelPiece(world -> ((SDFStructure)this.func_214627_k()).getSDF(start, (Random)this.field_214631_d).fillRecursive((StructureWorld)world, start), this.field_214631_d.nextInt());
            this.field_75075_a.add(piece);
            this.func_202500_a();
        }
    }
}

