/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.datagen;

import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import com.lilypuree.decorative_blocks.datagen.types.ModWoodTypes;
import com.lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import com.lilypuree.decorative_blocks.setup.Registration;
import net.minecraft.block.Block;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    private String name(Block block) {
        return block.getRegistryName().func_110623_a();
    }

    public void palisadeBlock(IWoodType wood) {
        this.palisadeInventory(wood);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)Registration.getPalisadeBlock(wood));
        ModelFile postModel = this.palisadePostPart(wood);
        ModelFile sideModel = this.palisadeSidePart(wood);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(postModel).addModel()).end().part().modelFile(sideModel).uvLock(true).addModel()).condition((Property)BlockStateProperties.field_208151_D, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile(sideModel).uvLock(true).rotationY(180).addModel()).condition((Property)BlockStateProperties.field_208153_F, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile(sideModel).uvLock(true).rotationY(90).addModel()).condition((Property)BlockStateProperties.field_208152_E, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile(sideModel).uvLock(true).rotationY(270).addModel()).condition((Property)BlockStateProperties.field_208154_G, (Comparable[])new Boolean[]{Boolean.TRUE}).end();
    }

    public ModelFile palisadePostPart(IWoodType wood) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.PALISADE, "post");
        return this.withSideEndTextures(builder, wood + "_palisade");
    }

    public ModelFile palisadeSidePart(IWoodType wood) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.PALISADE, "side");
        return this.withSideEndTextures(builder, wood + "_palisade");
    }

    public ModelFile palisadeInventory(IWoodType wood) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.PALISADE, "inventory");
        return this.withSideEndTextures(builder, wood + "_palisade");
    }

    public void beamBlock(IWoodType wood) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)Registration.getBeamBlock(wood));
        ModelFile beamXModel = this.beamModel(wood, Direction.Axis.X);
        ModelFile beamYModel = this.beamModel(wood, Direction.Axis.Y);
        ModelFile beamZModel = this.beamModel(wood, Direction.Axis.Z);
        builder.partialState().with((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X).modelForState().modelFile(beamXModel).addModel();
        builder.partialState().with((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Y).modelForState().modelFile(beamYModel).addModel();
        builder.partialState().with((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z).modelForState().modelFile(beamZModel).addModel();
    }

    public ModelFile beamModel(IWoodType wood, Direction.Axis axis) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.BEAM, axis.func_176719_a());
        return this.withSideEndTextures(builder, wood + "_beam");
    }

    public void seatBlock(IWoodType wood) {
        this.seatInventory(wood);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)Registration.getSeatBlock(wood));
        ModelFile seatTopModel = this.seatTopModel(wood);
        ModelFile seatPostModel = this.seatPostModel(wood);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(seatPostModel).addModel()).condition((Property)BlockStateProperties.field_208174_a, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile(seatTopModel).addModel()).condition((Property)BlockStateProperties.field_208157_J, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile(seatTopModel).rotationY(180).addModel()).condition((Property)BlockStateProperties.field_208157_J, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile(seatTopModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.field_208157_J, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile(seatTopModel).rotationY(270).addModel()).condition((Property)BlockStateProperties.field_208157_J, (Comparable[])new Direction[]{Direction.WEST}).end();
    }

    public ModelFile seatTopModel(IWoodType wood) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.SEAT, "top");
        return this.withParticleTexture(builder, wood + "_seat");
    }

    public ModelFile seatPostModel(IWoodType wood) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.SEAT, "post");
        return this.withParticleTexture(builder, wood + "_seat");
    }

    public ModelFile seatInventory(IWoodType wood) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.SEAT, "inventory");
        return this.withParticleTexture(builder, wood + "_seat");
    }

    public void supportBlock(IWoodType wood) {
        ModelFile supportUpModel = this.supportBlockModel(wood);
        ModelFile supportDownModel = this.supporBlockDownModel(wood);
        this.horizontalBlock((Block)Registration.getSupportBlock(wood), state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208149_B) != false ? supportUpModel : supportDownModel);
    }

    public ModelFile supportBlockModel(IWoodType wood) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.SUPPORT);
        return this.withParticleTexture(builder, wood + "_support");
    }

    public ModelFile supporBlockDownModel(IWoodType wood) {
        ModelBuilder<?> builder = this.createModel(wood, WoodDecorativeBlockTypes.SUPPORT, "down");
        return this.withParticleTexture(builder, wood + "_support");
    }

    private ModelBuilder<?> createModel(IWoodType wood, WoodDecorativeBlockTypes type) {
        return this.createModel(wood, type, null);
    }

    private ModelBuilder<?> createModel(IWoodType wood, WoodDecorativeBlockTypes type, String suffix) {
        String name = (Object)((Object)type) + (suffix == null ? "" : "_" + suffix);
        return ((BlockModelBuilder)this.models().getBuilder(wood + "_" + name)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/" + name)));
    }

    private ModelBuilder<?> withParticleTexture(ModelBuilder<?> model, String name) {
        ResourceLocation texture = this.modLoc("block/" + name);
        return model.texture("particle", texture).texture("texture", texture);
    }

    private ModelBuilder<?> withSideEndTextures(ModelBuilder<?> model, String name) {
        ResourceLocation side = this.modLoc("block/" + name + "_side");
        ResourceLocation end = this.modLoc("block/" + name + "_end");
        return model.texture("particle", side).texture("side", side).texture("end", end);
    }

    protected void registerStatesAndModels() {
        for (IWoodType wood : ModWoodTypes.allWoodTypes()) {
            this.beamBlock(wood);
            this.palisadeBlock(wood);
            this.seatBlock(wood);
            this.supportBlock(wood);
        }
        ModelBuilder builder = ((BlockModelBuilder)this.models().getBuilder("bar_panel_bottom")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/bar_panel_bottom")));
        ModelBuilder<?> barPanelBottomModel = this.withSideEndTextures(builder, "bar_panel");
        builder = ((BlockModelBuilder)this.models().getBuilder("bar_panel_top")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/bar_panel_top")));
        ModelBuilder<?> barPanelTopModel = this.withSideEndTextures(builder, "bar_panel");
        builder = ((BlockModelBuilder)this.models().getBuilder("bar_panel_open")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/bar_panel_open")));
        ModelBuilder<?> barPanelOpenModel = this.withSideEndTextures(builder, "bar_panel");
        this.trapdoorBlock((TrapDoorBlock)Registration.BAR_PANEL.get(), (ModelFile)barPanelBottomModel, (ModelFile)barPanelTopModel, (ModelFile)barPanelOpenModel, true);
        ModelBuilder chainModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("chain")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("custom/chain")))).texture("particle", this.modLoc("block/chain"))).texture("texture", this.modLoc("block/chain"));
    }
}

