/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.capabilities.Capabilities;
import appeng.core.Api;
import appeng.tile.AEBaseInvTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.CondenserItemInventory;
import appeng.tile.misc.CondenserVoidInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.AEItemFilters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CondenserTileEntity
extends AEBaseInvTileEntity
implements IConfigManagerHost,
IConfigurableObject {
    public static final int BYTE_MULTIPLIER = 8;
    private final ConfigManager cm = new ConfigManager(this);
    private final AppEngInternalInventory outputSlot = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory storageSlot = new AppEngInternalInventory(this, 1);
    private final IItemHandler inputSlot = new CondenseItemHandler();
    private final IFluidHandler fluidHandler = new FluidHandler();
    private final MEHandler meHandler = new MEHandler();
    private final IItemHandler externalInv = new WrapperChainedItemHandler(new IItemHandler[]{this.inputSlot, new WrapperFilteredItemHandler((IItemHandler)this.outputSlot, AEItemFilters.EXTRACT_ONLY)});
    private final IItemHandler combinedInv = new WrapperChainedItemHandler(new IItemHandler[]{this.inputSlot, this.outputSlot, this.storageSlot});
    private double storedPower = 0.0;

    public CondenserTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.cm.registerSetting(Settings.CONDENSER_OUTPUT, (Enum)CondenserOutput.TRASH);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        this.cm.writeToNBT(data);
        data.func_74780_a("storedPower", this.getStoredPower());
        return data;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.cm.readFromNBT(data);
        this.setStoredPower(data.func_74769_h("storedPower"));
    }

    public double getStorage() {
        IStorageComponent sc;
        ItemStack is = this.storageSlot.getStackInSlot(0);
        if (!is.func_190926_b() && is.func_77973_b() instanceof IStorageComponent && (sc = (IStorageComponent)is.func_77973_b()).isStorageComponent(is)) {
            return sc.getBytes(is) * 8;
        }
        return 0.0;
    }

    public void addPower(double rawPower) {
        this.setStoredPower(this.getStoredPower() + rawPower);
        this.setStoredPower(Math.max(0.0, Math.min(this.getStorage(), this.getStoredPower())));
        double requiredPower = this.getRequiredPower();
        ItemStack output = this.getOutput();
        while (requiredPower <= this.getStoredPower() && !output.func_190926_b() && requiredPower > 0.0 && this.canAddOutput(output)) {
            this.setStoredPower(this.getStoredPower() - requiredPower);
            this.addOutput(output);
        }
    }

    private boolean canAddOutput(ItemStack output) {
        return this.outputSlot.insertItem(0, output, true).func_190926_b();
    }

    private void addOutput(ItemStack output) {
        this.outputSlot.insertItem(0, output, false);
    }

    IItemHandler getOutputSlot() {
        return this.outputSlot;
    }

    private ItemStack getOutput() {
        IMaterials materials = Api.instance().definitions().materials();
        switch ((CondenserOutput)this.cm.getSetting(Settings.CONDENSER_OUTPUT)) {
            case MATTER_BALLS: {
                return materials.matterBall().maybeStack(1).orElse(ItemStack.field_190927_a);
            }
            case SINGULARITY: {
                return materials.singularity().maybeStack(1).orElse(ItemStack.field_190927_a);
            }
        }
        return ItemStack.field_190927_a;
    }

    public double getRequiredPower() {
        return ((CondenserOutput)this.cm.getSetting((Settings)Settings.CONDENSER_OUTPUT)).requiredPower;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.combinedInv;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.outputSlot) {
            this.meHandler.outputChanged(added, removed);
        }
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        this.addPower(0.0);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public double getStoredPower() {
        return this.storedPower;
    }

    private void setStoredPower(double storedPower) {
        this.storedPower = storedPower;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.externalInv);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.fluidHandler);
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return LazyOptional.of(() -> this.meHandler);
        }
        return super.getCapability(capability, facing);
    }

    private class MEHandler
    implements IStorageMonitorableAccessor,
    IStorageMonitorable {
        private final CondenserItemInventory itemInventory;

        private MEHandler() {
            this.itemInventory = new CondenserItemInventory(CondenserTileEntity.this);
        }

        void outputChanged(ItemStack added, ItemStack removed) {
            this.itemInventory.updateOutput(added, removed);
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            return this;
        }

        @Override
        public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
            if (channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                return this.itemInventory;
            }
            return new CondenserVoidInventory<T>(CondenserTileEntity.this, channel);
        }
    }

    private class FluidHandler
    implements IFluidTank,
    IFluidHandler {
        private FluidHandler() {
        }

        @Nonnull
        public FluidStack getFluid() {
            return FluidStack.EMPTY;
        }

        public int getFluidAmount() {
            return 0;
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean isFluidValid(FluidStack stack) {
            return !stack.isEmpty();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                IFluidStorageChannel chan = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
                CondenserTileEntity.this.addPower((resource.isEmpty() ? 0.0 : (double)resource.getAmount()) / (double)chan.transferFactor());
            }
            return resource.isEmpty() ? 0 : resource.getAmount();
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? this.getCapacity() : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0 && this.isFluidValid(stack);
        }
    }

    private class CondenseItemHandler
    implements IItemHandler {
        private CondenseItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0) {
                return stack;
            }
            if (!simulate && !stack.func_190926_b()) {
                CondenserTileEntity.this.addPower(stack.func_190916_E());
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

