/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEColor;
import appeng.core.Api;
import appeng.tile.crafting.CraftingMonitorModelData;
import appeng.tile.crafting.CraftingTileEntity;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;

public class CraftingMonitorTileEntity
extends CraftingTileEntity
implements IColorableTile {
    @OnlyIn(value=Dist.CLIENT)
    private Integer dspList;
    @OnlyIn(value=Dist.CLIENT)
    private boolean updateList;
    private IAEItemStack dspPlay;
    private AEColor paintedColor = AEColor.TRANSPARENT;

    public CraftingMonitorTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        boolean hasItem = data.readBoolean();
        this.dspPlay = hasItem ? AEItemStack.fromPacket(data) : null;
        this.setUpdateList(true);
        return oldPaintedColor != this.paintedColor || c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeByte(this.paintedColor.ordinal());
        if (this.dspPlay == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            this.dspPlay.writeToPacket(data);
        }
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        if (data.func_74764_b("paintedColor")) {
            this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        data.func_74774_a("paintedColor", (byte)this.paintedColor.ordinal());
        return data;
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isStatus() {
        return true;
    }

    public void setJob(IAEItemStack is) {
        if (is == null != (this.dspPlay == null)) {
            this.dspPlay = is == null ? null : is.copy();
            this.markForUpdate();
        } else if (is != null && this.dspPlay != null && is.getStackSize() != this.dspPlay.getStackSize()) {
            this.dspPlay = is.copy();
            this.markForUpdate();
        }
    }

    public IAEItemStack getJobProgress() {
        return this.dspPlay;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor newPaintedColor, PlayerEntity who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    public Integer getDisplayList() {
        return this.dspList;
    }

    public void setDisplayList(Integer dspList) {
        this.dspList = dspList;
    }

    public boolean isUpdateList() {
        return this.updateList;
    }

    public void setUpdateList(boolean updateList) {
        this.updateList = updateList;
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        Optional<ItemStack> is = Api.instance().definitions().blocks().craftingMonitor().maybeStack(1);
        return is.orElseGet(() -> super.getItemFromTile(obj));
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new CraftingMonitorModelData(this.getUp(), this.getForward(), this.getConnections(), this.getColor());
    }
}

