/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.client.render.BasicUnbakedModel;
import appeng.parts.automation.PlaneBakedModel;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;

public class PlaneModel
implements BasicUnbakedModel<PlaneModel> {
    private final RenderMaterial frontTexture;
    private final RenderMaterial sidesTexture;
    private final RenderMaterial backTexture;

    public PlaneModel(ResourceLocation frontTexture, ResourceLocation sidesTexture, ResourceLocation backTexture) {
        this.frontTexture = new RenderMaterial(AtlasTexture.field_110575_b, frontTexture);
        this.sidesTexture = new RenderMaterial(AtlasTexture.field_110575_b, sidesTexture);
        this.backTexture = new RenderMaterial(AtlasTexture.field_110575_b, backTexture);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite frontSprite = spriteGetter.apply(this.frontTexture);
        TextureAtlasSprite sidesSprite = spriteGetter.apply(this.sidesTexture);
        TextureAtlasSprite backSprite = spriteGetter.apply(this.backTexture);
        return new PlaneBakedModel(frontSprite, sidesSprite, backSprite);
    }

    @Override
    public Stream<RenderMaterial> getAdditionalTextures() {
        return Stream.of(this.frontTexture, this.sidesTexture, this.backTexture);
    }
}

