/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

final class VoxelShapeCache {
    private static final LoadingCache<List<AxisAlignedBB>, VoxelShape> CACHE = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<List<AxisAlignedBB>, VoxelShape>(){

        public VoxelShape load(List<AxisAlignedBB> key) {
            return VoxelShapeCache.create(key);
        }
    });

    private VoxelShapeCache() {
    }

    public static VoxelShape get(List<AxisAlignedBB> boxes) {
        return (VoxelShape)CACHE.getUnchecked(boxes);
    }

    private static VoxelShape create(List<AxisAlignedBB> boxes) {
        int i;
        if (boxes.isEmpty()) {
            return VoxelShapes.func_197880_a();
        }
        VoxelShape shape = VoxelShapes.func_197881_a((AxisAlignedBB)boxes.get(i));
        for (i = 0; i < boxes.size(); ++i) {
            AxisAlignedBB box = boxes.get(i);
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)box), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape.func_197753_c();
    }
}

