/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.Tooltip;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public interface ITooltip {
    @Nonnull
    default public List<ITextComponent> getTooltipMessage() {
        return Collections.emptyList();
    }

    public int getTooltipAreaX();

    public int getTooltipAreaY();

    public int getTooltipAreaWidth();

    public int getTooltipAreaHeight();

    public boolean isTooltipAreaVisible();

    @Nullable
    default public Tooltip getTooltip(int mouseX, int mouseY) {
        if (!this.isTooltipAreaVisible()) {
            return null;
        }
        int x = this.getTooltipAreaX();
        int y = this.getTooltipAreaY();
        if (x < mouseX && x + this.getTooltipAreaWidth() > mouseX && y < mouseY && y + this.getTooltipAreaHeight() > mouseY) {
            List<ITextComponent> lines = this.getTooltipMessage();
            if (lines.isEmpty()) {
                return null;
            }
            return new Tooltip(lines);
        }
        return null;
    }
}

