/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.util.AEColor;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.crafting.AbstractTableRenderer;
import appeng.container.me.crafting.CraftingStatusEntry;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.ReadableNumberConverter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class CraftingStatusTableRenderer
extends AbstractTableRenderer<CraftingStatusEntry> {
    private static final int BACKGROUND_ALPHA = 0x5A000000;

    public CraftingStatusTableRenderer(AEBaseScreen<?> screen, int x, int y) {
        super(screen, x, y);
    }

    @Override
    protected List<ITextComponent> getEntryDescription(CraftingStatusEntry entry) {
        String amount;
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>(3);
        if (entry.getStoredAmount() > 0L) {
            amount = ReadableNumberConverter.INSTANCE.toWideReadableForm(entry.getStoredAmount());
            lines.add((ITextComponent)GuiText.FromStorage.text(amount));
        }
        if (entry.getActiveAmount() > 0L) {
            amount = ReadableNumberConverter.INSTANCE.toWideReadableForm(entry.getActiveAmount());
            lines.add((ITextComponent)GuiText.Crafting.text(amount));
        }
        if (entry.getPendingAmount() > 0L) {
            amount = ReadableNumberConverter.INSTANCE.toWideReadableForm(entry.getPendingAmount());
            lines.add((ITextComponent)GuiText.Scheduled.text(amount));
        }
        return lines;
    }

    @Override
    protected ItemStack getEntryItem(CraftingStatusEntry entry) {
        return entry.getItem();
    }

    @Override
    protected List<ITextComponent> getEntryTooltip(CraftingStatusEntry entry) {
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>(this.screen.func_231151_a_(entry.getItem()));
        if (entry.getStoredAmount() > 0L) {
            lines.add((ITextComponent)GuiText.FromStorage.text(entry.getStoredAmount()));
        }
        if (entry.getActiveAmount() > 0L) {
            lines.add((ITextComponent)GuiText.Crafting.text(entry.getActiveAmount()));
        }
        if (entry.getPendingAmount() > 0L) {
            lines.add((ITextComponent)GuiText.Scheduled.text(entry.getPendingAmount()));
        }
        return lines;
    }

    @Override
    protected int getEntryBackgroundColor(CraftingStatusEntry entry) {
        if (AEConfig.instance().isUseColoredCraftingStatus()) {
            if (entry.getActiveAmount() > 0L) {
                return AEColor.GREEN.blackVariant | 0x5A000000;
            }
            if (entry.getPendingAmount() > 0L) {
                return AEColor.YELLOW.blackVariant | 0x5A000000;
            }
        }
        return 0;
    }
}

