/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.implementations.NumberEntryWidget;
import appeng.client.gui.style.ScreenStyle;
import appeng.container.me.crafting.CraftAmountContainer;
import appeng.core.localization.GuiText;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class CraftAmountScreen
extends AEBaseScreen<CraftAmountContainer> {
    private final Button next;
    private final NumberEntryWidget amountToCraft;
    private boolean initialAmountInitialized;

    public CraftAmountScreen(CraftAmountContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.next = this.widgets.addButton("next", GuiText.Next.text(), this::confirm);
        AESubScreen subGui = new AESubScreen(container.getTarget());
        subGui.addBackButton("back", this.widgets);
        this.amountToCraft = new NumberEntryWidget(NumberEntryType.CRAFT_ITEM_COUNT);
        this.amountToCraft.setValue(1L);
        this.amountToCraft.setTextFieldBounds(62, 57, 50);
        this.amountToCraft.setMinValue(1L);
        this.amountToCraft.setHideValidationIcon(true);
        this.amountToCraft.setOnConfirm(this::confirm);
        this.widgets.add("amountToCraft", this.amountToCraft);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        if (((CraftAmountContainer)this.field_147002_h).getInitialAmount() != -1 && !this.initialAmountInitialized) {
            this.amountToCraft.setValue(((CraftAmountContainer)this.field_147002_h).getInitialAmount());
            this.initialAmountInitialized = true;
        }
        this.next.func_238482_a_(CraftAmountScreen.func_231173_s_() ? GuiText.Start.text() : GuiText.Next.text());
        this.next.field_230693_o_ = this.amountToCraft.getIntValue().orElse(0) > 0;
    }

    private void confirm() {
        int amount = this.amountToCraft.getIntValue().orElse(0);
        if (amount <= 0) {
            return;
        }
        ((CraftAmountContainer)this.field_147002_h).confirm(amount, CraftAmountScreen.func_231173_s_());
    }

    @Override
    public void drawBG(MatrixStack matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrices, offsetX, offsetY, mouseX, mouseY, partialTicks);
        this.amountToCraft.render(matrices, offsetX, offsetY, partialTicks);
    }
}

