/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.InterfaceContainer;
import appeng.tile.misc.InterfaceTileEntity;
import appeng.util.InteractionUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class InterfaceBlock
extends AEBaseTileBlock<InterfaceTileEntity> {
    private static final BooleanProperty OMNIDIRECTIONAL = BooleanProperty.func_177716_a((String)"omnidirectional");

    public InterfaceBlock() {
        super(InterfaceBlock.defaultProps(Material.field_151573_f));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{OMNIDIRECTIONAL});
    }

    @Override
    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, InterfaceTileEntity te) {
        return (BlockState)currentState.func_206870_a((Property)OMNIDIRECTIONAL, (Comparable)Boolean.valueOf(te.isOmniDirectional()));
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity p, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        if (InteractionUtil.isInAlternateUseMode(p)) {
            return ActionResultType.PASS;
        }
        InterfaceTileEntity tg = (InterfaceTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tg != null) {
            if (!w.func_201670_d()) {
                ContainerOpener.openContainer(InterfaceContainer.TYPE, p, ContainerLocator.forTileEntitySide(tg, hit.func_216354_b()));
            }
            return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    @Override
    protected boolean hasCustomRotation() {
        return true;
    }

    @Override
    protected void customRotateBlock(IOrientable rotatable, Direction axis) {
        if (rotatable instanceof InterfaceTileEntity) {
            ((InterfaceTileEntity)rotatable).setSide(axis);
        }
    }
}

