/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlockBreakHandler {
    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        Item slabItem;
        BlockState state;
        SlabConverter slabConverter;
        Vector3d hitVec;
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        if (!KleeSlabs.isPlayerKleeSlabbing(event.getPlayer())) {
            return;
        }
        BlockRayTraceResult rayTraceResult = BlockBreakHandler.rayTrace((LivingEntity)event.getPlayer(), 6.0);
        Vector3d vector3d = hitVec = rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK ? rayTraceResult.func_216347_e() : null;
        if (hitVec != null) {
            hitVec = hitVec.func_72441_c((double)(-event.getPos().func_177958_n()), (double)(-event.getPos().func_177956_o()), (double)(-event.getPos().func_177952_p()));
        }
        if ((slabConverter = SlabRegistry.getSlabConverter((state = event.getState()).func_177230_c())) == null || !slabConverter.isDoubleSlab(state)) {
            return;
        }
        BlockState dropState = slabConverter.getSingleSlab(state, SlabType.BOTTOM);
        IWorld world = event.getWorld();
        if (!world.func_201670_d() && event.getPlayer().func_234569_d_(event.getState()) && !event.getPlayer().field_71075_bZ.field_75098_d && (slabItem = Item.func_150898_a((Block)dropState.func_177230_c())) != Items.field_190931_a) {
            ItemStack itemStack = new ItemStack((IItemProvider)slabItem);
            float scale = 0.7f;
            double xOffset = (double)(world.func_201674_k().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
            double yOffset = (double)(world.func_201674_k().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
            double zOffset = (double)(world.func_201674_k().nextFloat() * scale + 1.0f) - (double)scale * 0.5;
            ItemEntity entityItem = new ItemEntity((World)world, (double)event.getPos().func_177958_n() + xOffset, (double)event.getPos().func_177956_o() + yOffset, (double)event.getPos().func_177952_p() + zOffset, itemStack);
            entityItem.func_174867_a(10);
            world.func_217376_c((Entity)entityItem);
        }
        BlockState newState = hitVec != null && hitVec.field_72448_b < 0.5 ? slabConverter.getSingleSlab(state, SlabType.TOP) : slabConverter.getSingleSlab(state, SlabType.BOTTOM);
        event.getWorld().func_180501_a(event.getPos(), newState, 3);
        event.setCanceled(true);
    }

    public static BlockRayTraceResult rayTrace(LivingEntity entity, double length) {
        Vector3d startPos = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vector3d endPos = startPos.func_72441_c(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length);
        RayTraceContext rayTraceContext = new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity);
        return entity.field_70170_p.func_217299_a(rayTraceContext);
    }
}

