/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.RootCommandNode;
import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SCommandListPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.network.CommandTreeCleaner;
import net.minecraftforge.network.VanillaPacketFilter;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ChannelHandler.Sharable
public class VanillaConnectionNetworkFilter
extends VanillaPacketFilter {
    private static final Logger LOGGER = LogManager.getLogger();

    public VanillaConnectionNetworkFilter() {
        super((Map<Class<? extends IPacket<?>>, BiConsumer<IPacket<?>, List<? super IPacket<?>>>>)ImmutableMap.builder().put(VanillaConnectionNetworkFilter.handler(SEntityPropertiesPacket.class, VanillaConnectionNetworkFilter::filterEntityProperties)).put(VanillaConnectionNetworkFilter.handler(SCommandListPacket.class, VanillaConnectionNetworkFilter::filterCommandList)).build());
    }

    @Override
    protected boolean isNecessary(NetworkManager manager) {
        return NetworkHooks.isVanillaConnection(manager);
    }

    @Nonnull
    private static SEntityPropertiesPacket filterEntityProperties(SEntityPropertiesPacket msg) {
        SEntityPropertiesPacket newPacket = new SEntityPropertiesPacket(msg.func_149442_c(), Collections.emptyList());
        msg.func_149441_d().stream().filter(snapshot -> {
            ResourceLocation key = ForgeRegistries.ATTRIBUTES.getKey(snapshot.func_240834_a_());
            return key != null && key.func_110624_b().equals("minecraft");
        }).forEach(snapshot -> newPacket.func_149441_d().add(snapshot));
        return newPacket;
    }

    @Nonnull
    private static SCommandListPacket filterCommandList(SCommandListPacket packet) {
        RootCommandNode root = packet.func_197693_a();
        RootCommandNode newRoot = CommandTreeCleaner.cleanArgumentTypes(root, argType -> {
            ResourceLocation id = ArgumentTypes.getId((ArgumentType)argType);
            return id != null && (id.func_110624_b().equals("minecraft") || id.func_110624_b().equals("brigadier"));
        });
        return new SCommandListPacket(newRoot);
    }
}

