/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityAttributeModificationEvent
extends Event
implements IModBusEvent {
    private final Map<EntityType<? extends LivingEntity>, AttributeModifierMap.MutableAttribute> entityAttributes;
    private final List<EntityType<? extends LivingEntity>> entityTypes;

    public EntityAttributeModificationEvent(Map<EntityType<? extends LivingEntity>, AttributeModifierMap.MutableAttribute> mapIn) {
        this.entityAttributes = mapIn;
        this.entityTypes = ImmutableList.copyOf((Collection)ForgeRegistries.ENTITIES.getValues().stream().filter(GlobalEntityTypeAttributes::func_233837_b_).map(entityType -> entityType).collect(Collectors.toList()));
    }

    public void add(EntityType<? extends LivingEntity> entityType, Attribute attribute, double value) {
        AttributeModifierMap.MutableAttribute attributes = this.entityAttributes.computeIfAbsent(entityType, type -> new AttributeModifierMap.MutableAttribute());
        attributes.func_233815_a_(attribute, value);
    }

    public void add(EntityType<? extends LivingEntity> entityType, Attribute attribute) {
        this.add(entityType, attribute, attribute.func_111110_b());
    }

    public boolean has(EntityType<? extends LivingEntity> entityType, Attribute attribute) {
        AttributeModifierMap globalMap = GlobalEntityTypeAttributes.func_233835_a_(entityType);
        return globalMap.func_233809_c_(attribute) || this.entityAttributes.get(entityType) != null && this.entityAttributes.get(entityType).hasAttribute(attribute);
    }

    public List<EntityType<? extends LivingEntity>> getTypes() {
        return this.entityTypes;
    }
}

