/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.commoncapabilities.api.capability.block.IBlockCapabilityConstructor;
import org.cyclops.commoncapabilities.api.capability.block.IBlockCapabilityProvider;

public class BlockCapabilities
implements IBlockCapabilityProvider {
    private List<IBlockCapabilityConstructor> capabilityConstructors = Lists.newLinkedList();
    private final Map<Block, IBlockCapabilityProvider[]> providers = Maps.newIdentityHashMap();
    private static final BlockCapabilities INSTANCE = new BlockCapabilities();

    private BlockCapabilities() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    public static BlockCapabilities getInstance() {
        return INSTANCE;
    }

    protected void register(@Nullable Block block, @Nonnull IBlockCapabilityProvider capabilityProvider) {
        Object[] providers = this.providers.get(block);
        if (providers == null) {
            providers = new IBlockCapabilityProvider[]{};
        }
        providers = (IBlockCapabilityProvider[])ArrayUtils.add((Object[])providers, (Object)capabilityProvider);
        this.providers.put(block, (IBlockCapabilityProvider[])providers);
    }

    public void register(@Nonnull IBlockCapabilityConstructor capabilityConstructor) {
        if (ForgeRegistries.BLOCKS.getKeys().isEmpty() && this.capabilityConstructors != null) {
            this.capabilityConstructors.add(capabilityConstructor);
        } else {
            this.register(capabilityConstructor.getBlock(), capabilityConstructor.createProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void afterBlocksRegistered(RegistryEvent.Register<Block> event) {
        for (IBlockCapabilityConstructor capabilityConstructor : this.capabilityConstructors) {
            this.register(capabilityConstructor.getBlock(), capabilityConstructor.createProvider());
        }
        this.capabilityConstructors = null;
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull BlockState blockState, @Nonnull Capability<T> capability, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction facing) {
        block3: {
            IBlockCapabilityProvider[] providers;
            block2: {
                providers = this.providers.get(blockState.func_177230_c());
                if (providers == null) break block2;
                for (IBlockCapabilityProvider provider : providers) {
                    LazyOptional<T> capabilityHolder = provider.getCapability(blockState, capability, world, pos, facing);
                    if (!capabilityHolder.isPresent()) continue;
                    return capabilityHolder;
                }
                break block3;
            }
            providers = this.providers.get(null);
            if (providers == null) break block3;
            for (IBlockCapabilityProvider provider : providers) {
                LazyOptional<T> capabilityHolder = provider.getCapability(blockState, capability, world, pos, facing);
                if (!capabilityHolder.isPresent()) continue;
                return capabilityHolder;
            }
        }
        return LazyOptional.empty();
    }
}

