/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.forge.gui.entries.TextFieldListEntry;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DoubleListEntry
extends TextFieldListEntry<Double> {
    private static Function<String, String> stripCharacters = s -> {
        StringBuilder stringBuilder_1 = new StringBuilder();
        char[] var2 = s.toCharArray();
        int var3 = var2.length;
        for (char c : var2) {
            if (!Character.isDigit(c) && c != '-' && c != '.') continue;
            stringBuilder_1.append(c);
        }
        return stringBuilder_1.toString();
    };
    private double minimum = -1.7976931348623157E308;
    private double maximum = Double.MAX_VALUE;
    private Consumer<Double> saveConsumer;

    @Deprecated
    public DoubleListEntry(ITextComponent fieldName, Double value, ITextComponent resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    public DoubleListEntry(ITextComponent fieldName, Double value, ITextComponent resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    public DoubleListEntry(ITextComponent fieldName, Double value, ITextComponent resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }

    @Override
    protected void textFieldPreRender(TextFieldWidget widget) {
        try {
            double i = Double.parseDouble(this.textFieldWidget.func_146179_b());
            if (i < this.minimum || i > this.maximum) {
                widget.func_146193_g(0xFF5555);
            } else {
                widget.func_146193_g(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.func_146193_g(0xFF5555);
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() && text.equals(((Double)this.defaultValue.get()).toString());
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public DoubleListEntry setMinimum(double minimum) {
        this.minimum = minimum;
        return this;
    }

    public DoubleListEntry setMaximum(double maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public Double getValue() {
        try {
            return Double.valueOf(this.textFieldWidget.func_146179_b());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public Optional<ITextComponent> getError() {
        try {
            double i = Double.parseDouble(this.textFieldWidget.func_146179_b());
            if (i > this.maximum) {
                return Optional.of(new TranslationTextComponent("text.cloth-config.error.too_large", new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(new TranslationTextComponent("text.cloth-config.error.too_small", new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(new TranslationTextComponent("text.cloth-config.error.not_valid_number_double"));
        }
        return super.getError();
    }
}

