/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.blocks.SkilletBlock;
import vectorwing.farmersdelight.mixin.accessors.RecipeManagerAccessor;
import vectorwing.farmersdelight.registry.ModParticleTypes;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.FDSyncedTileEntity;
import vectorwing.farmersdelight.tile.IHeatableTileEntity;
import vectorwing.farmersdelight.utils.ItemUtils;
import vectorwing.farmersdelight.utils.TextUtils;

public class SkilletTileEntity
extends FDSyncedTileEntity
implements ITickableTileEntity,
IHeatableTileEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private int cookingTime;
    private int cookingTimeTotal;
    private ResourceLocation lastRecipeID;
    private ItemStack skilletStack = ItemStack.field_190927_a;
    private int fireAspectLevel;

    public SkilletTileEntity() {
        super((TileEntityType)ModTileEntityTypes.SKILLET_TILE.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        boolean isHeated = this.isHeated(this.field_145850_b, this.field_174879_c);
        if (!this.field_145850_b.field_72995_K) {
            if (isHeated) {
                ItemStack cookingStack = this.getStoredStack();
                if (cookingStack.func_190926_b()) {
                    this.cookingTime = 0;
                } else {
                    this.cookAndOutputItems(cookingStack);
                }
            } else if (this.cookingTime > 0) {
                this.cookingTime = MathHelper.func_76125_a((int)(this.cookingTime - 2), (int)0, (int)this.cookingTimeTotal);
            }
        } else if (isHeated && this.hasStoredStack()) {
            this.addCookingParticles();
        }
    }

    private void cookAndOutputItems(ItemStack cookingStack) {
        Inventory wrapper;
        Optional<CampfireCookingRecipe> recipe;
        if (this.field_145850_b == null) {
            return;
        }
        ++this.cookingTime;
        if (this.cookingTime >= this.cookingTimeTotal && (recipe = this.getMatchingRecipe((IInventory)(wrapper = new Inventory(new ItemStack[]{cookingStack})))).isPresent()) {
            ItemStack resultStack = recipe.get().func_77572_b((IInventory)wrapper);
            Direction direction = ((Direction)this.func_195044_w().func_177229_b((Property)SkilletBlock.field_185512_D)).func_176746_e();
            ItemUtils.spawnItemEntity(this.field_145850_b, resultStack.func_77946_l(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.3, (double)this.field_174879_c.func_177952_p() + 0.5, (float)direction.func_82601_c() * 0.08f, 0.25, (float)direction.func_82599_e() * 0.08f);
            this.cookingTime = 0;
            this.inventory.extractItem(0, 1, false);
        }
    }

    public boolean isCooking() {
        return this.isHeated() && this.hasStoredStack();
    }

    public boolean isHeated() {
        if (this.field_145850_b != null) {
            return this.isHeated(this.field_145850_b, this.field_174879_c);
        }
        return false;
    }

    private Optional<CampfireCookingRecipe> getMatchingRecipe(IInventory recipeWrapper) {
        IRecipe recipe;
        if (this.field_145850_b == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.field_145850_b.func_199532_z()).getRecipeMap(IRecipeType.field_222153_e).get(this.lastRecipeID)) instanceof CampfireCookingRecipe && recipe.func_77569_a(recipeWrapper, this.field_145850_b)) {
            return Optional.of((CampfireCookingRecipe)recipe);
        }
        recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, recipeWrapper, this.field_145850_b);
        if (recipe.isPresent()) {
            this.lastRecipeID = ((CampfireCookingRecipe)recipe.get()).func_199560_c();
            return recipe;
        }
        return Optional.empty();
    }

    private void addCookingParticles() {
        if (this.field_145850_b != null) {
            double z;
            double y;
            double x;
            Random random = this.field_145850_b.field_73012_v;
            if (random.nextFloat() < 0.2f) {
                x = (double)this.field_174879_c.func_177958_n() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                y = (double)this.field_174879_c.func_177956_o() + 0.1;
                z = (double)this.field_174879_c.func_177952_p() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                double motionY = random.nextBoolean() ? 0.015 : 0.005;
                this.field_145850_b.func_195594_a((IParticleData)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
            if (this.fireAspectLevel > 0 && random.nextFloat() < (float)this.fireAspectLevel * 0.05f) {
                x = (double)this.field_174879_c.func_177958_n() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                y = (double)this.field_174879_c.func_177956_o() + 0.1;
                z = (double)this.field_174879_c.func_177952_p() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                double motionX = this.field_145850_b.field_73012_v.nextFloat() - 0.5f;
                double motionY = this.field_145850_b.field_73012_v.nextFloat() * 0.5f + 0.2f;
                double motionZ = this.field_145850_b.field_73012_v.nextFloat() - 0.5f;
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197622_o, x, y, z, motionX, motionY, motionZ);
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.cookingTime = compound.func_74762_e("CookTime");
        this.cookingTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.skilletStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Skillet"));
        this.fireAspectLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.skilletStack);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compound.func_74768_a("CookTime", this.cookingTime);
        compound.func_74768_a("CookTimeTotal", this.cookingTimeTotal);
        compound.func_218657_a("Skillet", (INBT)this.skilletStack.func_77955_b(new CompoundNBT()));
        return compound;
    }

    public CompoundNBT writeSkilletItem(CompoundNBT compound) {
        compound.func_218657_a("Skillet", (INBT)this.skilletStack.func_77955_b(new CompoundNBT()));
        return compound;
    }

    public void setSkilletItem(ItemStack stack) {
        this.skilletStack = stack.func_77946_l();
        this.fireAspectLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack);
        this.inventoryChanged();
    }

    public ItemStack addItemToCook(ItemStack addedStack, @Nullable PlayerEntity player) {
        Optional<CampfireCookingRecipe> recipe = this.getMatchingRecipe((IInventory)new Inventory(new ItemStack[]{addedStack}));
        if (recipe.isPresent()) {
            this.cookingTimeTotal = SkilletBlock.getSkilletCookingTime(recipe.get().func_222137_e(), this.fireAspectLevel);
            boolean wasEmpty = this.getStoredStack().func_190926_b();
            ItemStack remainderStack = this.inventory.insertItem(0, addedStack.func_77946_l(), false);
            if (!ItemStack.func_179545_c((ItemStack)remainderStack, (ItemStack)addedStack)) {
                this.lastRecipeID = recipe.get().func_199560_c();
                this.cookingTime = 0;
                if (wasEmpty && this.field_145850_b != null && this.isHeated(this.field_145850_b, this.field_174879_c)) {
                    this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundCategory.BLOCKS, 0.8f, 1.0f);
                }
                return remainderStack;
            }
        } else if (player != null) {
            player.func_146105_b((ITextComponent)TextUtils.getTranslation("block.skillet.invalid_item", new Object[0]), true);
        }
        return addedStack;
    }

    public ItemStack removeItem() {
        return this.inventory.extractItem(0, this.getStoredStack().func_77976_d(), false);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredStack() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean hasStoredStack() {
        return !this.getStoredStack().func_190926_b();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            protected void onContentsChanged(int slot) {
                SkilletTileEntity.this.inventoryChanged();
            }
        };
    }

    public void func_145843_s() {
        super.func_145843_s();
    }
}

