/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.SkilletTileEntity;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class SkilletBlock
extends HorizontalBlock {
    public static final int MINIMUM_COOKING_TIME = 60;
    public static final BooleanProperty SUPPORT = BooleanProperty.func_177716_a((String)"support");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = VoxelShapes.func_197872_a((VoxelShape)SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public SkilletBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(0.5f, 6.0f).func_200947_a(SoundType.field_222475_v));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)SUPPORT, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof SkilletTileEntity) {
            SkilletTileEntity skilletEntity = (SkilletTileEntity)tileEntity;
            if (!worldIn.field_72995_K) {
                EquipmentSlotType heldSlot;
                ItemStack heldStack = player.func_184586_b(handIn);
                EquipmentSlotType equipmentSlotType = heldSlot = handIn.equals((Object)Hand.MAIN_HAND) ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
                if (heldStack.func_190926_b()) {
                    ItemStack extractedStack = skilletEntity.removeItem();
                    if (!player.func_184812_l_()) {
                        player.func_184201_a(heldSlot, extractedStack);
                    }
                    return ActionResultType.SUCCESS;
                }
                ItemStack remainderStack = skilletEntity.addItemToCook(heldStack, player);
                if (remainderStack.func_190916_E() != heldStack.func_190916_E()) {
                    if (!player.func_184812_l_()) {
                        player.func_184201_a(heldSlot, remainderStack);
                    }
                    worldIn.func_184133_a(null, pos, SoundEvents.field_219640_fO, SoundCategory.BLOCKS, 0.7f, 1.0f);
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof SkilletTileEntity) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((SkilletTileEntity)tileEntity).getInventory().getStackInSlot(0));
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((Boolean)state.func_177229_b((Property)SUPPORT)).equals(true) ? SHAPE_WITH_TRAY : SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f())).func_206870_a((Property)SUPPORT, (Comparable)Boolean.valueOf(this.getTrayState((IWorld)context.func_195991_k(), context.func_195995_a())));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176740_k().equals((Object)Direction.Axis.Y)) {
            return (BlockState)state.func_206870_a((Property)SUPPORT, (Comparable)Boolean.valueOf(this.getTrayState(world, currentPos)));
        }
        return state;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack stack = super.func_185473_a(worldIn, pos, state);
        SkilletTileEntity skilletEntity = (SkilletTileEntity)worldIn.func_175625_s(pos);
        CompoundNBT nbt = skilletEntity.writeSkilletItem(new CompoundNBT());
        if (!nbt.isEmpty()) {
            stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Skillet"));
        }
        return stack;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, SUPPORT});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        SkilletTileEntity skilletEntity;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof SkilletTileEntity && (skilletEntity = (SkilletTileEntity)tileEntity).isCooking()) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = pos.func_177956_o();
            double z = (double)pos.func_177952_p() + 0.5;
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a(x, y, z, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get(), SoundCategory.BLOCKS, 0.4f, rand.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.SKILLET_TILE.get()).func_200968_a();
    }

    private boolean getTrayState(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.TRAY_HEAT_SOURCES);
    }

    public static int getSkilletCookingTime(int originalCookingTime, int fireAspectLevel) {
        int cookingTime = originalCookingTime > 0 ? originalCookingTime : 600;
        int cookingSeconds = cookingTime / 20;
        float cookingTimeReduction = 0.2f;
        if (fireAspectLevel > 0) {
            cookingTimeReduction = (float)((double)cookingTimeReduction - (double)fireAspectLevel * 0.05);
        }
        int result = (int)((float)cookingSeconds * cookingTimeReduction) * 20;
        return MathHelper.func_76125_a((int)result, (int)60, (int)originalCookingTime);
    }
}

