/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.filters;

import net.darkhax.darkutils.features.filters.IFilterTest;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockFilter
extends Block {
    public static final VoxelShape EMPTY = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public static final AbstractBlock.Properties BLOCK_PROPERTIES = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(3.0f, 10.0f).func_235842_b_((a, b, c) -> false).func_235847_c_((a, b, c) -> false).func_226896_b_();
    private final IFilterTest filter;

    public BlockFilter(IFilterTest filter) {
        this(filter, BLOCK_PROPERTIES);
    }

    public BlockFilter(IFilterTest filter, AbstractBlock.Properties properties) {
        super(properties);
        this.filter = filter;
        BlockState defaultState = (BlockState)this.field_176227_L.func_177621_b();
        defaultState = (BlockState)defaultState.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.func_206870_a((Property)BlockStateProperties.field_208188_o, (Comparable)Boolean.valueOf(false));
        this.func_180632_j(defaultState);
    }

    public IFilterTest getFilter(BlockState state, IBlockReader world, BlockPos pos) {
        return this.filter;
    }

    public boolean shouldInvertFilter(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208188_o);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208194_u, BlockStateProperties.field_208188_o});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState placedState = super.func_196258_a(context);
        placedState = (BlockState)placedState.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
        return placedState;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208188_o, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208188_o) == false)), 3);
                world.func_217379_c(1008, pos, 0);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, handIn, hit);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isBlockPowered = worldIn.func_175640_z(pos);
        if (!worldIn.field_72995_K && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != isBlockPowered) {
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.5f);
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(isBlockPowered)));
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public boolean func_181623_g() {
        return true;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() != null && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue()) {
            boolean filterMatch = this.getFilter(state, world, pos).test(state, pos, world, context.getEntity());
            if (this.shouldInvertFilter(state, world, pos) ? !filterMatch : filterMatch) {
                return EMPTY;
            }
        }
        return super.func_220071_b(state, world, pos, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_203425_a((Block)this);
    }
}

