/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.registry;

import hellfirepvp.astralsorcery.common.event.StarlightNetworkEvent;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimplePrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionSourceNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.CrystalPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.CrystalTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionProvider;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverAltar;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverRitualPedestal;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverTreeBeacon;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverWell;
import hellfirepvp.astralsorcery.common.tile.network.StarlightTransmissionLens;
import hellfirepvp.astralsorcery.common.tile.network.StarlightTransmissionPrism;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TransmissionClassRegistry {
    public static final TransmissionClassRegistry eventInstance = new TransmissionClassRegistry();
    private static final Map<ResourceLocation, TransmissionProvider> providerMap = new HashMap<ResourceLocation, TransmissionProvider>();

    private TransmissionClassRegistry() {
    }

    public void registerProvider(TransmissionProvider provider) {
        TransmissionClassRegistry.register(provider);
    }

    @Nullable
    public static TransmissionProvider getProvider(ResourceLocation identifier) {
        return providerMap.get(identifier);
    }

    public static void register(TransmissionProvider provider) {
        if (providerMap.containsKey(provider.getIdentifier())) {
            throw new RuntimeException("Already registered identifier TransmissionProvider: " + provider.getIdentifier());
        }
        providerMap.put(provider.getIdentifier(), provider);
    }

    public static void setupRegistry() {
        TransmissionClassRegistry.register(new SimpleTransmissionNode.Provider());
        TransmissionClassRegistry.register(new SimplePrismTransmissionNode.Provider());
        TransmissionClassRegistry.register(new SimpleTransmissionSourceNode.Provider());
        TransmissionClassRegistry.register(new CrystalTransmissionNode.Provider());
        TransmissionClassRegistry.register(new CrystalPrismTransmissionNode.Provider());
        TransmissionClassRegistry.register(new StarlightReceiverWell.Provider());
        TransmissionClassRegistry.register(new StarlightReceiverRitualPedestal.Provider());
        TransmissionClassRegistry.register(new StarlightReceiverAltar.Provider());
        TransmissionClassRegistry.register(new StarlightReceiverTreeBeacon.Provider());
        TransmissionClassRegistry.register(new StarlightTransmissionLens.Provider());
        TransmissionClassRegistry.register(new StarlightTransmissionPrism.Provider());
        MinecraftForge.EVENT_BUS.post((Event)new StarlightNetworkEvent.TransmissionRegister(eventInstance));
    }
}

