/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.reader;

import hellfirepvp.astralsorcery.common.perk.PerkAttributeMap;
import hellfirepvp.astralsorcery.common.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import java.text.DecimalFormat;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class PerkAttributeReader
extends ForgeRegistryEntry<PerkAttributeReader> {
    private static final DecimalFormat percentageFormat = new DecimalFormat("0.00");
    private final PerkAttributeType type;

    protected PerkAttributeReader(PerkAttributeType type) {
        this.type = type;
        this.setRegistryName(this.type.getRegistryName());
    }

    public final PerkAttributeType getType() {
        return this.type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract PerkStatistic getStatistics(PerkAttributeMap var1, PlayerEntity var2);

    public abstract double getDefaultValue(PerkAttributeMap var1, PlayerEntity var2, LogicalSide var3);

    public abstract double getModifierValueForMode(PerkAttributeMap var1, PlayerEntity var2, LogicalSide var3, ModifierType var4);

    public static String formatDecimal(double decimal) {
        return percentageFormat.format(decimal);
    }
}

