/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class KeyVoidTrash
extends KeyPerk {
    private static final float defaultOreChance = 0.02f;
    private static final List<Item> defaultTrashItems = new ArrayList<Item>(){
        {
            this.add(Blocks.field_150346_d.func_199767_j());
            this.add(Blocks.field_150347_e.func_199767_j());
            this.add(Blocks.field_196656_g.func_199767_j());
            this.add(Blocks.field_196654_e.func_199767_j());
            this.add(Blocks.field_196650_c.func_199767_j());
            this.add(Blocks.field_150348_b.func_199767_j());
            this.add(Blocks.field_150351_n.func_199767_j());
        }
    };
    public static final Config CONFIG = new Config("key.void_trash");

    public KeyVoidTrash(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue oreChance;
        private ForgeConfigSpec.ConfigValue<List<String>> trashItems;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.trashItems = cfgBuilder.comment("List items that should count as trash and should be voided.").translation(this.translationKey("trashItems")).define("trashItems", defaultTrashItems.stream().map(item -> item.getRegistryName().toString()).collect(Collectors.toList()));
            this.oreChance = cfgBuilder.comment("Chance that a voided drop will instead yield a random ore out of the configured ore table.").translation(this.translationKey("oreChance")).defineInRange("oreChance", (double)0.02f, 0.0, 1.0);
        }

        public boolean isTrash(ItemStack stack) {
            String key = stack.func_77973_b().getRegistryName().toString();
            return ((List)this.trashItems.get()).contains(key);
        }

        public double getOreChance() {
            return (Double)this.oreChance.get();
        }
    }
}

