/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.data.LoadedPerkData;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class PreparedPerkTreeData {
    private final List<PerkTreePoint<AbstractPerk>> treePoints = new LinkedList<PerkTreePoint<AbstractPerk>>();
    private final Map<AbstractPerk, Collection<AbstractPerk>> doubleConnections = new HashMap<AbstractPerk, Collection<AbstractPerk>>();
    private final List<Tuple<AbstractPerk, AbstractPerk>> connections = new LinkedList<Tuple<AbstractPerk, AbstractPerk>>();
    private final Map<IConstellation, RootPerk> rootPerks = new HashMap<IConstellation, RootPerk>();
    private long version = 0L;

    PreparedPerkTreeData() {
    }

    static PreparedPerkTreeData create(Collection<LoadedPerkData> perks) {
        PreparedPerkTreeData treeData = new PreparedPerkTreeData();
        perks.stream().map(LoadedPerkData::getPerk).forEach(perk -> {
            PerkTreePoint<? extends AbstractPerk> offsetPoint;
            if (perk instanceof RootPerk) {
                treeData.rootPerks.put(((RootPerk)perk).getConstellation(), (RootPerk)perk);
            }
            if (treeData.treePoints.contains(offsetPoint = perk.getPoint())) {
                throw new IllegalArgumentException("Tried to register perk-point at already placed position: " + offsetPoint.getOffset().toString());
            }
            treeData.treePoints.add(offsetPoint);
        });
        perks.forEach(perkData -> {
            for (ResourceLocation connection : perkData.getConnections()) {
                AbstractPerk perkTo = treeData.getPerk(perk -> connection.equals((Object)perk.getRegistryName())).orElseThrow(() -> new JsonParseException("Cannot connect to unknown perk: " + connection));
                treeData.getConnector(perkTo).ifPresent(connector -> connector.connect(perkData.getPerk()));
            }
        });
        treeData.version = treeData.computeTreeHash();
        return treeData;
    }

    public long getVersion() {
        return this.version;
    }

    public Optional<AbstractPerk> getPerk(Predicate<AbstractPerk> test) {
        return this.treePoints.stream().map(PerkTreePoint::getPerk).filter(test).findFirst();
    }

    public Optional<? extends AbstractPerk> getPerk(float x, float y) {
        return this.treePoints.stream().filter(treePoint -> treePoint.getOffset().distance(x, y) <= 1.0E-4).findFirst().map(PerkTreePoint::getPerk);
    }

    @Nullable
    public RootPerk getRootPerk(IConstellation constellation) {
        return this.rootPerks.get(constellation);
    }

    public Collection<AbstractPerk> getConnectedPerks(AbstractPerk perk) {
        return this.doubleConnections.getOrDefault(perk, Lists.newArrayList());
    }

    public Collection<PerkTreePoint<?>> getPerkPoints() {
        return Collections.unmodifiableList(this.treePoints);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Collection<Tuple<AbstractPerk, AbstractPerk>> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    private Optional<PointConnector> getConnector(AbstractPerk point) {
        if (point == null) {
            return Optional.empty();
        }
        if (this.treePoints.contains(point.getPoint())) {
            return Optional.of(new PointConnector(point));
        }
        return Optional.empty();
    }

    private long computeTreeHash() {
        long[] perkHash = new long[this.treePoints.size()];
        for (int i = 0; i < this.treePoints.size(); ++i) {
            PerkTreePoint<AbstractPerk> treePoint = this.treePoints.get(i);
            perkHash[i] = (long)treePoint.getPerk().hashCode() << 32 ^ (long)treePoint.getOffset().hashCode();
        }
        long hash = 1L;
        for (long element : perkHash) {
            long elementHash = element ^ element >>> 32;
            hash = 31L * hash + elementHash;
        }
        return hash;
    }

    public void clearPerkCache(LogicalSide side) {
        this.treePoints.stream().map(PerkTreePoint::getPerk).forEach(p -> p.clearCaches(side));
    }

    public class PointConnector {
        private final AbstractPerk point;

        private PointConnector(AbstractPerk point) {
            this.point = point;
        }

        public PointConnector connect(AbstractPerk other) {
            if (other == null) {
                return this;
            }
            Collection pointsTo = PreparedPerkTreeData.this.doubleConnections.computeIfAbsent(other, p -> new LinkedList());
            if (!pointsTo.contains(this.point)) {
                pointsTo.add(this.point);
            }
            if (!(pointsTo = PreparedPerkTreeData.this.doubleConnections.computeIfAbsent(this.point, p -> new LinkedList())).contains(other)) {
                pointsTo.add(other);
            }
            Tuple connection = new Tuple((Object)this.point, (Object)other);
            Tuple reverse = new Tuple((Object)other, (Object)this.point);
            if (!PreparedPerkTreeData.this.connections.contains(connection) && !PreparedPerkTreeData.this.connections.contains(reverse)) {
                PreparedPerkTreeData.this.connections.add(connection);
            }
            return this;
        }

        public PointConnector connect(PointConnector other) {
            return this.connect(other.point);
        }

        public PointConnector chain(PointConnector other) {
            this.connect(other.point);
            return other;
        }
    }
}

