/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.data.LoadedPerkData;
import hellfirepvp.astralsorcery.common.perk.data.PerkTreeData;
import hellfirepvp.astralsorcery.common.perk.data.PerkTypeHandler;
import hellfirepvp.astralsorcery.common.util.MapStream;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class PerkTreeLoader
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final PerkTreeLoader INSTANCE = new PerkTreeLoader();

    private PerkTreeLoader() {
        super(GSON, "perks");
    }

    protected void apply(Map<ResourceLocation, JsonElement> dataMap, IResourceManager resourceManager, IProfiler profiler) {
        Collection loadingPerkObjects = MapStream.of(dataMap).filterKey(key -> !key.func_110623_a().startsWith("_")).filterValue(JsonElement::isJsonObject).mapValue(JsonElement::getAsJsonObject).valueStream().collect(Collectors.toList());
        PerkTree.PERK_TREE.updateOriginPerkTree(PerkTreeLoader.loadPerkTree(loadingPerkObjects));
    }

    public static PerkTreeData loadPerkTree(Collection<JsonObject> perkTreeObjects) {
        PerkTreeData newTree = new PerkTreeData();
        int count = 0;
        for (JsonObject serializedPerkData : perkTreeObjects) {
            ResourceLocation perkRegistryName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)serializedPerkData, (String)"registry_name"));
            ResourceLocation customClass = PerkTypeHandler.DEFAULT.getKey();
            if (serializedPerkData.has("perk_class") && !PerkTypeHandler.hasCustomType(customClass = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)serializedPerkData, (String)"perk_class")))) {
                throw new JsonParseException("Unknown perk_class: " + customClass.toString());
            }
            float posX = JSONUtils.func_151217_k((JsonObject)serializedPerkData, (String)"x");
            float posY = JSONUtils.func_151217_k((JsonObject)serializedPerkData, (String)"y");
            Object perk = PerkTypeHandler.convert(perkRegistryName, posX, posY, customClass);
            if (serializedPerkData.has("name")) {
                String name = JSONUtils.func_151200_h((JsonObject)serializedPerkData, (String)"name");
                ((AbstractPerk)perk).setName(name);
            }
            if (serializedPerkData.has("hiddenUnlessAllocated")) {
                ((AbstractPerk)perk).setHiddenUnlessAllocated(JSONUtils.func_151212_i((JsonObject)serializedPerkData, (String)"hiddenUnlessAllocated"));
            }
            if (serializedPerkData.has("data")) {
                JsonObject perkData = JSONUtils.func_152754_s((JsonObject)serializedPerkData, (String)"data");
                ((AbstractPerk)perk).deserializeData(perkData);
            }
            LoadedPerkData connector = newTree.addPerk((AbstractPerk)perk, serializedPerkData);
            if (serializedPerkData.has("connection")) {
                JsonArray connectionArray = JSONUtils.func_151214_t((JsonObject)serializedPerkData, (String)"connection");
                for (int i = 0; i < connectionArray.size(); ++i) {
                    JsonElement connection = connectionArray.get(i);
                    String connectedPerkKey = JSONUtils.func_151206_a((JsonElement)connection, (String)String.format("connection[%s]", i));
                    connector.addConnection(new ResourceLocation(connectedPerkKey));
                }
            }
            ++count;
        }
        AstralSorcery.log.info("Built PerkTree with {} perks!", (Object)count);
        return newTree;
    }
}

