/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerPerkData;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.network.play.server.PktSyncKnowledge;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class PlayerProgress {
    private List<ResourceLocation> knownConstellations = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> seenConstellations = new ArrayList<ResourceLocation>();
    private ProgressionTier tierReached = ProgressionTier.DISCOVERY;
    private Set<ResearchProgression> researchProgression = new HashSet<ResearchProgression>();
    private IMajorConstellation attunedConstellation = null;
    private boolean wasOnceAttuned = false;
    private final PlayerPerkData perkData = new PlayerPerkData();
    private List<ResourceLocation> storedConstellationPapers = new ArrayList<ResourceLocation>();
    private boolean tomeReceived = false;
    private boolean usePerkAbilities = true;

    public void load(CompoundNBT compound) {
        ResourceLocation s;
        int i;
        ListNBT list;
        this.knownConstellations.clear();
        this.seenConstellations.clear();
        this.researchProgression.clear();
        this.storedConstellationPapers.clear();
        this.attunedConstellation = null;
        this.tierReached = ProgressionTier.DISCOVERY;
        this.wasOnceAttuned = false;
        this.tomeReceived = false;
        this.usePerkAbilities = true;
        if (compound.func_74764_b("seenConstellations")) {
            list = compound.func_150295_c("seenConstellations", 8);
            for (i = 0; i < list.size(); ++i) {
                this.seenConstellations.add(new ResourceLocation(list.func_150307_f(i)));
            }
        }
        if (compound.func_74764_b("constellations")) {
            list = compound.func_150295_c("constellations", 8);
            for (i = 0; i < list.size(); ++i) {
                s = new ResourceLocation(list.func_150307_f(i));
                this.knownConstellations.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("storedConstellationPapers")) {
            list = compound.func_150295_c("storedConstellationPapers", 8);
            for (i = 0; i < list.size(); ++i) {
                s = new ResourceLocation(list.func_150307_f(i));
                this.storedConstellationPapers.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("attuned")) {
            String cst = compound.func_74779_i("attuned");
            IConstellation c = ConstellationRegistry.getConstellation(new ResourceLocation(cst));
            if (!(c instanceof IMajorConstellation)) {
                AstralSorcery.log.warn("Failed to load attuned Constellation: " + cst + " - constellation doesn't exist or isn't major.");
            } else {
                this.attunedConstellation = (IMajorConstellation)c;
            }
        }
        this.perkData.load(this, compound);
        if (compound.func_74764_b("tierReached")) {
            int tierOrdinal = compound.func_74762_e("tierReached");
            this.tierReached = MiscUtils.getEnumEntry(ProgressionTier.class, tierOrdinal);
        }
        if (compound.func_74764_b("research")) {
            int[] research;
            for (int resOrdinal : research = compound.func_74759_k("research")) {
                this.researchProgression.add(MiscUtils.getEnumEntry(ResearchProgression.class, resOrdinal));
            }
        }
        this.wasOnceAttuned = compound.func_74767_n("wasAttuned");
        this.tomeReceived = !compound.func_74764_b("bookReceived") ? true : compound.func_74767_n("bookReceived");
        if (compound.func_74764_b("usePerkAbilities")) {
            this.usePerkAbilities = compound.func_74767_n("usePerkAbilities");
        }
    }

    public void store(CompoundNBT cmp) {
        ListNBT known = new ListNBT();
        for (ResourceLocation resourceLocation : this.knownConstellations) {
            known.add((Object)StringNBT.func_229705_a_((String)resourceLocation.toString()));
        }
        ListNBT seen = new ListNBT();
        for (ResourceLocation resourceLocation : this.seenConstellations) {
            seen.add((Object)StringNBT.func_229705_a_((String)resourceLocation.toString()));
        }
        ListNBT listNBT = new ListNBT();
        for (ResourceLocation s : this.storedConstellationPapers) {
            listNBT.add((Object)StringNBT.func_229705_a_((String)s.toString()));
        }
        cmp.func_218657_a("constellations", (INBT)known);
        cmp.func_218657_a("seenConstellations", (INBT)seen);
        cmp.func_218657_a("storedConstellationPapers", (INBT)listNBT);
        cmp.func_74768_a("tierReached", this.tierReached.ordinal());
        cmp.func_74757_a("wasAttuned", this.wasOnceAttuned);
        int[] nArray = this.researchProgression.stream().mapToInt(Enum::ordinal).toArray();
        cmp.func_74783_a("research", nArray);
        if (this.attunedConstellation != null) {
            cmp.func_74778_a("attuned", this.attunedConstellation.getRegistryName().toString());
        }
        PerkTree.PERK_TREE.getVersion(LogicalSide.SERVER).ifPresent(version -> cmp.func_74772_a("perkTreeVersion", version.longValue()));
        cmp.func_74757_a("bookReceived", this.tomeReceived);
        cmp.func_74757_a("usePerkAbilities", this.usePerkAbilities);
        this.perkData.save(cmp);
    }

    public void storeKnowledge(CompoundNBT cmp) {
        ListNBT list = new ListNBT();
        for (ResourceLocation resourceLocation : this.knownConstellations) {
            list.add((Object)StringNBT.func_229705_a_((String)resourceLocation.toString()));
        }
        ListNBT l = new ListNBT();
        for (ResourceLocation s : this.seenConstellations) {
            l.add((Object)StringNBT.func_229705_a_((String)s.toString()));
        }
        cmp.func_218657_a("constellations", (INBT)list);
        cmp.func_218657_a("seenConstellations", (INBT)l);
        cmp.func_74768_a("tierReached", this.tierReached.ordinal());
        cmp.func_74757_a("wasAttuned", this.wasOnceAttuned);
        int[] nArray = this.researchProgression.stream().mapToInt(Enum::ordinal).toArray();
        cmp.func_74783_a("research", nArray);
    }

    public void loadKnowledge(CompoundNBT compound) {
        int tierOrdinal;
        ProgressionTier otherTier;
        ResourceLocation cstName;
        int i;
        ListNBT list;
        if (compound.func_74764_b("seenConstellations")) {
            list = compound.func_150295_c("seenConstellations", 8);
            for (i = 0; i < list.size(); ++i) {
                cstName = new ResourceLocation(list.func_150307_f(i));
                if (this.seenConstellations.contains(cstName)) continue;
                this.seenConstellations.add(cstName);
            }
        }
        if (compound.func_74764_b("constellations")) {
            list = compound.func_150295_c("constellations", 8);
            for (i = 0; i < list.size(); ++i) {
                cstName = new ResourceLocation(list.func_150307_f(i));
                if (!this.knownConstellations.contains(cstName)) {
                    this.knownConstellations.add(cstName);
                }
                if (this.seenConstellations.contains(cstName)) continue;
                this.seenConstellations.add(cstName);
            }
        }
        if (compound.func_74764_b("tierReached") && (otherTier = MiscUtils.getEnumEntry(ProgressionTier.class, tierOrdinal = compound.func_74762_e("tierReached"))).isThisLater(this.tierReached)) {
            this.tierReached = otherTier;
        }
        if (compound.func_74764_b("research")) {
            int[] research;
            for (int resOrdinal : research = compound.func_74759_k("research")) {
                this.researchProgression.add(MiscUtils.getEnumEntry(ResearchProgression.class, resOrdinal));
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public PlayerPerkData getPerkData() {
        return this.perkData;
    }

    protected void setAttunedConstellation(IMajorConstellation constellation) {
        this.attunedConstellation = constellation;
        this.wasOnceAttuned = true;
    }

    public Collection<ResearchProgression> getResearchProgression() {
        return Collections.unmodifiableCollection(this.researchProgression);
    }

    public boolean hasResearch(ResearchProgression progression) {
        return this.getResearchProgression().contains((Object)progression);
    }

    protected boolean forceGainResearch(ResearchProgression progression) {
        return this.researchProgression.add(progression);
    }

    public ProgressionTier getTierReached() {
        return this.tierReached;
    }

    public IMajorConstellation getAttunedConstellation() {
        return this.attunedConstellation;
    }

    public boolean isAttuned() {
        return this.getAttunedConstellation() != null;
    }

    public boolean wasOnceAttuned() {
        return this.wasOnceAttuned;
    }

    protected void setAttunedBefore(boolean attuned) {
        this.wasOnceAttuned = attuned;
    }

    public boolean didReceiveTome() {
        return this.tomeReceived;
    }

    protected void setTomeReceived() {
        this.tomeReceived = true;
    }

    public boolean doPerkAbilities() {
        return this.usePerkAbilities;
    }

    protected void setUsePerkAbilities(boolean usePerkAbilities) {
        this.usePerkAbilities = usePerkAbilities;
    }

    protected void setTierReached(ProgressionTier tier) {
        this.tierReached = tier;
    }

    public List<ResourceLocation> getKnownConstellations() {
        return this.knownConstellations;
    }

    public List<ResourceLocation> getSeenConstellations() {
        return this.seenConstellations;
    }

    public List<ResourceLocation> getStoredConstellationPapers() {
        return this.storedConstellationPapers;
    }

    public boolean hasSeenConstellation(IConstellation constellation) {
        return this.hasSeenConstellation(constellation.getRegistryName());
    }

    public boolean hasSeenConstellation(ResourceLocation constellation) {
        return this.seenConstellations.contains(constellation);
    }

    public boolean hasConstellationDiscovered(IConstellation constellation) {
        return this.hasConstellationDiscovered(constellation.getRegistryName());
    }

    public boolean hasConstellationDiscovered(ResourceLocation constellation) {
        return this.knownConstellations.contains(constellation);
    }

    protected void discoverConstellation(ResourceLocation name) {
        this.memorizeConstellation(name);
        if (!this.knownConstellations.contains(name)) {
            this.knownConstellations.add(name);
        }
    }

    protected void memorizeConstellation(ResourceLocation name) {
        if (!this.seenConstellations.contains(name)) {
            this.seenConstellations.add(name);
        }
    }

    protected void setStoredConstellationPapers(List<ResourceLocation> names) {
        this.storedConstellationPapers.clear();
        this.storedConstellationPapers.addAll(names);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void receive(PktSyncKnowledge message) {
        this.knownConstellations = message.knownConstellations;
        this.seenConstellations = message.seenConstellations;
        this.storedConstellationPapers = message.storedConstellationPapers;
        this.researchProgression = new HashSet<ResearchProgression>(message.researchProgression);
        this.tierReached = MiscUtils.getEnumEntry(ProgressionTier.class, message.progressTier);
        this.attunedConstellation = message.attunedConstellation;
        this.wasOnceAttuned = message.wasOnceAttuned;
        this.perkData.receive(message);
        this.usePerkAbilities = message.doPerkAbilities;
    }

    protected PlayerProgress copy() {
        PlayerProgress copy = new PlayerProgress();
        CompoundNBT saveData = new CompoundNBT();
        this.store(saveData);
        copy.load(saveData);
        return copy;
    }

    public void acceptMergeFrom(PlayerProgress toMergeFrom) {
        for (ResourceLocation seen : toMergeFrom.seenConstellations) {
            this.memorizeConstellation(seen);
        }
        for (ResourceLocation known : toMergeFrom.knownConstellations) {
            this.discoverConstellation(known);
        }
        if (toMergeFrom.tierReached.isThisLaterOrEqual(this.tierReached)) {
            this.tierReached = toMergeFrom.tierReached;
        }
        for (ResearchProgression prog : toMergeFrom.researchProgression) {
            this.forceGainResearch(prog);
        }
    }
}

