/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.base;

import com.google.common.base.Splitter;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ModConfig;

public class BaseConfiguration {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final Splitter DOT_SPLITTER = Splitter.on((String)".");
    private final List<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
    private final ModConfig.Type configType;

    protected BaseConfiguration(ModConfig.Type configType) {
        this.configType = configType;
    }

    public <T extends ConfigEntry> T addConfigEntry(T configEntry) {
        configEntry.setConfigType(this.configType);
        this.configEntries.add(configEntry);
        return configEntry;
    }

    public void buildConfiguration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        for (ConfigEntry entry : this.configEntries) {
            List splitPath = DOT_SPLITTER.splitToList((CharSequence)entry.getPath());
            builder.push(splitPath);
            entry.accept(builder);
            builder.pop(splitPath.size());
        }
        BaseConfiguration.makeAndRegister(this.configType, builder.build(), "astralsorcery");
    }

    static void makeAndRegister(ModConfig.Type type, ForgeConfigSpec spec, String file) {
        String fileName = type == ModConfig.Type.SERVER ? String.format("%s.toml", file) : String.format("%s-%s.toml", file, type.extension());
        ModContainer ct = AstralSorcery.getModContainer();
        ModConfig cfg = new ModConfig(type, spec, ct, fileName);
        ct.addConfig(cfg);
    }
}

