/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.function;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public interface RefreshFunction<T extends EntityComplexFX> {
    public static final RefreshFunction<?> DESPAWN = fx -> false;

    public static <E extends TileEntity, T extends EntityComplexFX> RefreshFunction<T> tileExists(E tile) {
        return new TileExists(tile);
    }

    public static <E extends TileEntity, T extends EntityComplexFX> RefreshFunction<T> tileExistsAnd(E tile, BiPredicate<E, T> refreshFct) {
        TileExists fct = new TileExists(tile);
        return fx -> Optional.ofNullable(fct.getTileIfValid()).map(t -> refreshFct.test(t, fx)).orElse(false);
    }

    public boolean shouldRefresh(@Nonnull T var1);

    public static class TileExists<E extends TileEntity, T extends EntityComplexFX>
    implements RefreshFunction<T> {
        private final RegistryKey<World> dimType;
        private final BlockPos pos;
        private final Class<E> clazzExpected;

        public TileExists(E tile) {
            this.dimType = tile.func_145831_w().func_234923_W_();
            this.pos = tile.func_174877_v();
            this.clazzExpected = tile.getClass();
        }

        @Override
        public boolean shouldRefresh(@Nonnull T fx) {
            return this.getTileIfValid() != null;
        }

        @Nullable
        protected E getTileIfValid() {
            TileEntity tile;
            ClientWorld clWorld = Minecraft.func_71410_x().field_71441_e;
            if (clWorld != null && clWorld.func_234923_W_().equals(this.dimType) && (tile = (TileEntity)MiscUtils.getTileAt((IBlockReader)clWorld, this.pos, this.clazzExpected, true)) != null && !tile.func_145837_r()) {
                return (E)tile;
            }
            return null;
        }
    }
}

