/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.verification;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import me.shedaniel.architectury.platform.Platform;
import net.creeperhost.minetogether.MineTogether;
import org.apache.commons.io.FileUtils;

public class SignatureVerifier {
    private final File jarFile = this.findOurJar(Platform.getGameFolder().resolve("mods").toFile());

    public String verify() {
        byte[] fileBytes;
        MessageDigest messageDigest;
        if (this.jarFile == null) {
            return "Development";
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "Development";
        }
        try {
            fileBytes = FileUtils.readFileToByteArray((File)this.jarFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Development";
        }
        messageDigest.update(fileBytes);
        return SignatureVerifier.bytesToHex(messageDigest.digest());
    }

    private File findOurJar(File modsFolder) {
        try {
            MineTogether.logger.info("Scanning mods directory for MineTogether jar");
            File[] modsDir = modsFolder.listFiles();
            if (modsDir == null) {
                return null;
            }
            for (File file : modsDir) {
                try {
                    Map<String, Attributes> attributesMap;
                    JarFile jarFile;
                    if (file.isDirectory() || !file.getName().endsWith(".jar") || (jarFile = new JarFile(file)) == null || jarFile.getManifest() == null || (attributesMap = jarFile.getManifest().getEntries()) == null) continue;
                    for (String s2 : attributesMap.keySet()) {
                        if (!s2.equalsIgnoreCase("net/creeperhost/minetogether/MineTogether.class")) continue;
                        MineTogether.logger.error("Main class found, MineTogether Jar found");
                        try {
                            jarFile.close();
                            jarFile = new JarFile(file, true);
                        }
                        catch (SecurityException ignored) {
                            ignored.printStackTrace();
                            return null;
                        }
                        return file;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

