/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.threads;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.util.WebUtils;

public class FriendUpdateThread {
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    public static void init() {
        Runnable runnable = FriendUpdateThread::updateFriendsList;
        executorService.scheduleAtFixedRate(runnable, 0L, 30L, TimeUnit.SECONDS);
    }

    public static void updateFriendsList() {
        try {
            JsonObject obj;
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("hash", ChatCallbacks.getPlayerHash(MineTogetherClient.getUUID()));
            String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/listfriend", new Gson().toJson(sendMap), true, true);
            JsonElement el = new JsonParser().parse(resp);
            if (el.isJsonObject() && (obj = el.getAsJsonObject()).get("status").getAsString().equals("success")) {
                JsonArray array = obj.getAsJsonArray("friends");
                for (JsonElement friendEl : array) {
                    String code;
                    JsonObject friend = (JsonObject)friendEl;
                    String name = "null";
                    if (!friend.get("name").isJsonNull()) {
                        name = friend.get("name").getAsString();
                    }
                    String string = code = friend.get("hash").isJsonNull() ? "" : friend.get("hash").getAsString();
                    boolean accepted = friend.get("accepted").getAsBoolean();
                    if (!accepted) continue;
                    Profile friendProfile = KnownUsers.findByHash(code);
                    if (friendProfile == null) {
                        friendProfile = KnownUsers.add(code);
                    }
                    friendProfile.setFriendName(name);
                    friendProfile.setFriend(true);
                    KnownUsers.update(friendProfile);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stop() {
        try {
            executorService.shutdownNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

