/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.oauth.KeycloakOAuth;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SettingsScreen
extends MineTogetherScreen {
    private final Screen parent;
    private Button linkButton;

    public SettingsScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("minetogether.settings.title"));
        this.parent = parent;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 123, 40, 120, 20, (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)("Chat Enabled: " + this.format(Config.getInstance().isChatEnabled())), (Object[])new Object[0])), p -> {
            if (Config.getInstance().isChatEnabled()) {
                MineTogether.logger.info("Disabling in-game chat");
                Config.getInstance().setChatEnabled(false);
                IrcHandler.stop(true);
            } else {
                MineTogether.logger.info("Enabling in-game chat");
                Config.getInstance().setChatEnabled(true);
                IrcHandler.reconnect();
                ChatModule.getMineTogetherChat().startChat();
            }
            this.saveConfig();
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 3, 40, 120, 20, (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)("Friend Toasts: " + this.format(Config.getInstance().isFriendOnlineToastsEnabled())), (Object[])new Object[0])), p -> {
            boolean enabled = Config.getInstance().isFriendOnlineToastsEnabled();
            Config.getInstance().setEnableFriendOnlineToasts(!enabled);
            this.saveConfig();
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 123, 60, 120, 20, (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)("Menu Buttons: " + this.format(Config.getInstance().isEnableMainMenuFriends())), (Object[])new Object[0])), p -> {
            boolean enabled = Config.getInstance().isEnableMainMenuFriends();
            Config.getInstance().setEnableMainMenuFriends(!enabled);
            this.saveConfig();
        }));
        this.linkButton = new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 47, 200, 20, (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"minetogether.settingscreen.button.linkaccount", (Object[])new Object[0])), p -> this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(e -> {
            if (e) {
                KeycloakOAuth.main(new String[0]);
            }
            this.field_230706_i_.func_147108_a((Screen)this);
        }, (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"minetogether.linkaccount1", (Object[])new Object[0])), (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"minetogether.linkaccount2", (Object[])new Object[0])))));
        this.func_230480_a_((Widget)this.linkButton);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 27, 200, 20, (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])), p -> this.field_230706_i_.func_147108_a(this.parent)));
    }

    public void func_231023_e_() {
        this.linkButton.field_230693_o_ = Config.getInstance().getFirstConnect();
        super.func_231023_e_();
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
        this.func_231165_f_(1);
        super.func_230430_a_(poseStack, i, j, f);
        SettingsScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
    }

    public String format(boolean value) {
        return value ? TextFormatting.GREEN + "Enabled" : TextFormatting.RED + "Disabled";
    }

    private void saveConfig() {
        Config.saveConfigToFile(MineTogether.configFile.toFile());
        this.field_230706_i_.func_147108_a((Screen)new SettingsScreen(this.parent));
    }
}

