/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.serverorder.DefferedValidation;
import net.creeperhost.minetogether.lib.serverorder.IOrderValidation;
import net.creeperhost.minetogether.lib.serverorder.RegexValidator;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.module.serverorder.screen.OrderServerScreen;
import net.creeperhost.minetogether.module.serverorder.screen.listentries.ListEntryCountry;
import net.creeperhost.minetogether.module.serverorder.widget.TextFieldDetails;
import net.creeperhost.minetogethergui.lists.ScreenList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class PersonalDetailsScreen
extends OrderServerScreen {
    public List<TextFieldDetails> fields = null;
    public TextFieldDetails focusedField;
    public boolean isEmailValid = false;
    private boolean loginMode;
    private Button loginButton;
    private boolean loggingIn;
    private String loggingInError = "";
    private boolean loggedIn;
    private boolean isSure;
    private boolean orderPressed;
    private ITextComponent info2 = null;
    private String prevLoginString;
    private boolean prevLoginVisible;
    private boolean prevLoginEnabled;
    private boolean renderList = false;
    private boolean first = false;
    private ScreenList list;
    private Button selectCountry;
    private Button buttonList;
    private TextFieldWidget searchEntry;

    public PersonalDetailsScreen(int stepId, Order order) {
        super(stepId, order);
        order.clientID = "";
    }

    @Override
    public String getStepName() {
        return I18n.func_135052_a((String)"minetogether.screen.personal_details", (Object[])new Object[0]);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.list = new ScreenList(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 56, this.field_230709_l_ - 36, 36);
        this.func_230481_d_((IGuiEventListener)this.list);
        this.searchEntry = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 80, this.field_230709_l_ - 32, 160, 20, (ITextComponent)new TranslationTextComponent(""));
        this.func_230481_d_((IGuiEventListener)this.searchEntry);
        this.updateList();
        this.loginButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 - 10, 80, 20, (ITextComponent)new TranslationTextComponent("minetogether.button.login"), p -> {
            if (this.orderPressed && !this.isSure) {
                this.isSure = true;
                this.buttonNext.func_230930_b_();
                return;
            }
            this.loggingIn = true;
            this.loginButton.field_230693_o_ = false;
            this.loginButton.func_238482_a_((ITextComponent)new TranslationTextComponent("minetogether.button.logging"));
            CompletableFuture.runAsync(() -> {
                String result = ServerOrderCallbacks.doLogin(this.order.emailAddress, this.order.password);
                String[] resultSplit = result.split(":");
                if (resultSplit[0].equals("success")) {
                    this.order.currency = resultSplit[1] != null ? resultSplit[1] : "1";
                    this.order.clientID = resultSplit[2] != null ? resultSplit[2] : "98874";
                    this.loggingIn = false;
                    this.loggedIn = true;
                    this.loggingInError = "";
                    this.loginButton.func_238482_a_((ITextComponent)new TranslationTextComponent("minetogether.button.done"));
                } else {
                    this.loggingIn = false;
                    this.loggedIn = false;
                    this.loggingInError = result;
                    this.loginButton.field_230693_o_ = true;
                    this.loginButton.func_238482_a_((ITextComponent)new TranslationTextComponent("minetogether.button.logintryagain"));
                }
            });
        }));
        this.loginButton.field_230694_p_ = this.loginMode;
        if (this.orderPressed && !this.isSure) {
            this.loginButton.func_238482_a_((ITextComponent)new TranslationTextComponent("button.order"));
            this.loginButton.field_230693_o_ = true;
            this.loginButton.field_230694_p_ = true;
            this.buttonNext.field_230694_p_ = false;
        } else if (this.loggingIn) {
            this.loginButton.func_238482_a_((ITextComponent)new TranslationTextComponent("button.logging"));
            this.loginButton.field_230693_o_ = false;
        } else if (this.loggedIn) {
            this.loginButton.func_238482_a_((ITextComponent)new TranslationTextComponent("button.done"));
            this.loginButton.field_230693_o_ = false;
        } else if (!this.loggingInError.isEmpty()) {
            this.loginButton.func_238482_a_((ITextComponent)new TranslationTextComponent("button.logintryagain"));
        }
        this.fields = new ArrayList<TextFieldDetails>();
        int x = this.field_230708_k_ / 2;
        int fieldWidths = 185;
        ArrayList<IOrderValidation> defaultValidators = new ArrayList<IOrderValidation>();
        defaultValidators.add(new IOrderValidation(){

            @Override
            public boolean validationCheckAtPhase(IOrderValidation.ValidationPhase phase) {
                return phase.equals((Object)IOrderValidation.ValidationPhase.CHANGED);
            }

            @Override
            public boolean isValid(String string) {
                return !string.isEmpty();
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            public String getValidationMessage() {
                return "Cannot be blank";
            }

            @Override
            public String getName() {
                return "NotBlankValidator";
            }
        });
        ArrayList<IOrderValidation> emailValidators = new ArrayList<IOrderValidation>(defaultValidators);
        emailValidators.add(new RegexValidator("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", "Invalid email address"));
        emailValidators.add(new DefferedValidation(){

            @Override
            public boolean validationCheckAtPhase(IOrderValidation.ValidationPhase phase) {
                return phase.equals((Object)IOrderValidation.ValidationPhase.FOCUSLOST);
            }

            @Override
            public boolean isValidReal(String string) {
                return ServerOrderCallbacks.doesEmailExist(string);
            }

            @Override
            public String getMessageReal() {
                return "Email already exists";
            }

            @Override
            public String getName() {
                return "NotEmailExistsValidator";
            }
        });
        this.fields.add(new TextFieldDetails(this, 0, I18n.func_135052_a((String)"minetogether.info.e_mail", (Object[])new Object[0]), this.order.emailAddress, x - 205, 45, fieldWidths, 20, emailValidators));
        this.fields.add(new TextFieldDetails(this, 1, I18n.func_135052_a((String)"minetogether.info.password", (Object[])new Object[0]), this.order.password, x + 5, 45, fieldWidths, 20, defaultValidators, "*"));
        this.fields.add(new TextFieldDetails(this, 2, I18n.func_135052_a((String)"minetogether.info.first_name", (Object[])new Object[0]), this.order.firstName, x - 205, 75, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 3, I18n.func_135052_a((String)"minetogether.info.last_name", (Object[])new Object[0]), this.order.lastName, x + 5, 75, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 4, I18n.func_135052_a((String)"minetogether.info.address", (Object[])new Object[0]), this.order.address, x - 205, 105, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 5, I18n.func_135052_a((String)"minetogether.info.city", (Object[])new Object[0]), this.order.city, x + 5, 105, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 6, I18n.func_135052_a((String)"minetogether.info.zip", (Object[])new Object[0]), this.order.zip, x - 205, 135, fieldWidths, 20, defaultValidators));
        this.fields.add(new TextFieldDetails(this, 7, I18n.func_135052_a((String)"minetogether.info.state", (Object[])new Object[0]), this.order.state, x + 5, 135, fieldWidths, 20, defaultValidators));
        String buttonName = ServerOrderCallbacks.getCountries().get(this.order.country);
        if (buttonName == null || buttonName.isEmpty()) {
            buttonName = "Invalid";
        }
        this.buttonList = new Button(x - 205, 165, fieldWidths, 20, (ITextComponent)new TranslationTextComponent(buttonName), p -> {
            this.renderList = true;
        });
        this.func_230480_a_((Widget)this.buttonList);
        this.selectCountry = new Button(this.field_230708_k_ - 90, this.field_230709_l_ - 30, 80, 20, (ITextComponent)new TranslationTextComponent("minetogether.button.select"), button -> {
            this.renderList = false;
            ListEntryCountry listEntryCountry = (ListEntryCountry)((Object)((Object)this.list.getCurrSelected()));
            this.order.country = listEntryCountry.countryID;
            this.buttonList.func_238482_a_((ITextComponent)new TranslationTextComponent(ServerOrderCallbacks.getCountries().get(listEntryCountry.countryID)));
        });
        this.func_230480_a_((Widget)this.selectCountry);
        this.fields.add(new TextFieldDetails(this, 9, I18n.func_135052_a((String)"minetogether.info.phone", (Object[])new Object[0]), this.order.phone, x + 5, 165, fieldWidths, 20, defaultValidators));
        String info2Text = I18n.func_135052_a((String)"minetogether.order.info2", (Object[])new Object[0]);
        String regex = "\\((.*?)\\|(.*?)\\)";
        Pattern pattern = Pattern.compile("\\((.*?)\\|(.*?)\\)");
        Matcher matcher = pattern.matcher(info2Text);
        int lastEnd = 0;
        TranslationTextComponent component = null;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String part = info2Text.substring(lastEnd, start);
            if (part.length() > 0) {
                if (component == null) {
                    component = new TranslationTextComponent(part);
                } else {
                    component.func_230532_e_().func_230529_a_((ITextComponent)new TranslationTextComponent(part));
                }
            }
            lastEnd = end;
            TranslationTextComponent link = new TranslationTextComponent(matcher.group(1));
            Style style = link.func_150256_b();
            style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, matcher.group(2)));
            style.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE));
            style.func_244282_c(Boolean.valueOf(true));
            style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent(I18n.func_135052_a((String)"order.url", (Object[])new Object[0]))));
            if (component == null) {
                component = link;
                continue;
            }
            component.func_230532_e_().func_230529_a_((ITextComponent)new TranslationTextComponent(link.getString()));
        }
        this.info2 = component;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.selectCountry.field_230693_o_ = this.renderList;
        this.selectCountry.field_230694_p_ = this.renderList;
        this.buttonCancel.field_230693_o_ = !this.renderList;
        this.buttonCancel.field_230694_p_ = !this.renderList;
        this.buttonPrev.field_230693_o_ = !this.renderList;
        this.buttonPrev.field_230694_p_ = !this.renderList;
        this.buttonList.field_230693_o_ = !this.renderList && !this.loginMode;
        this.buttonList.field_230694_p_ = !this.renderList && !this.loginMode;
        this.buttonNext.field_230693_o_ = !this.renderList;
        this.buttonNext.field_230694_p_ = !this.renderList;
        this.buttonNext.field_230693_o_ = true;
        boolean bl = this.loginButton.field_230694_p_ = this.loginMode || this.orderPressed && !this.isSure;
        if (this.loggedIn) {
            this.field_230706_i_.func_147108_a(PersonalDetailsScreen.getByStep(this.stepId + 1, this.order, null));
        }
        for (TextFieldDetails field : this.fields) {
            field.checkPendingValidations();
            field.func_146178_a();
            if (field.isValidated) continue;
            this.buttonNext.field_230693_o_ = false;
        }
        this.buttonNext.field_230693_o_ = this.buttonNext.field_230693_o_ && this.isEmailValid;
        this.buttonNext.field_230693_o_ = this.loggedIn || this.buttonNext.field_230693_o_;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(0);
        PersonalDetailsScreen.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)(this.field_230709_l_ - 20), (int)this.field_230708_k_, (int)20, (int)-1728053248);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.renderList) {
            this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.searchEntry.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            if (!(this.orderPressed && this.isSure || this.loginMode)) {
                PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"No data will be sent until you complete the order.", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 45), (int)0xFFFFFF);
            }
            if (!this.orderPressed || this.isSure) {
                for (TextFieldDetails field : this.fields) {
                    if (this.loginMode) {
                        if (field.getId() >= 2) continue;
                        field.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                        continue;
                    }
                    field.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
                if (this.loginMode) {
                    if (this.loggingIn) {
                        PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.details.login", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 20), (int)0xFFFFFF);
                    } else if (!this.loggingInError.isEmpty()) {
                        PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(I18n.func_135052_a((String)"minetogether.details.loginerror", (Object[])new Object[0]) + this.loggingInError), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 20), (int)0xFFFFFF);
                    } else if (this.loggedIn) {
                        PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.details.loginsuccess", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 20), (int)0xFFFFFF);
                    } else {
                        PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.details.accountexists", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 20), (int)0xFFFFFF);
                    }
                }
            } else {
                int info2Start = this.field_230709_l_ / 2 - 50;
                PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"order.info1", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 60), (int)0xFFFFFF);
                PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.info2.getString(), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 50), (int)0xFFFFFF);
                PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"order.info3", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 30), (int)0xFFFFFF);
                PersonalDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"order.info4", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 20), (int)0xFFFFFF);
                if (mouseY >= info2Start) {
                    HoverEvent event;
                    ITextComponent component;
                    Objects.requireNonNull(this.field_230712_o_);
                    if (mouseY <= info2Start + 9 && (component = this.getComponent(mouseX, mouseY)) != null && (event = component.func_150256_b().func_150210_i()) != null && event.func_150701_a() == HoverEvent.Action.field_230550_a_) {
                        this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent(event.toString()), mouseX, mouseY);
                    }
                }
            }
        }
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.searchEntry.func_230999_j_()) {
            boolean flag = this.searchEntry.func_231042_a_(typedChar, keyCode);
            this.updateList();
            return flag;
        }
        TextFieldDetails field = this.focusedField;
        if (this.focusedField == null) {
            return false;
        }
        if (field.func_231042_a_(typedChar, keyCode)) {
            int id = field.getId();
            String text = field.func_146179_b().trim();
            switch (id) {
                case 0: {
                    this.order.emailAddress = text;
                    break;
                }
                case 1: {
                    this.order.password = text;
                    break;
                }
                case 2: {
                    this.order.firstName = text;
                    break;
                }
                case 3: {
                    this.order.lastName = text;
                    break;
                }
                case 4: {
                    this.order.address = text;
                    break;
                }
                case 5: {
                    this.order.city = text;
                    break;
                }
                case 6: {
                    this.order.zip = text;
                    break;
                }
                case 7: {
                    this.order.state = text;
                    break;
                }
                case 8: {
                    this.order.country = text;
                    break;
                }
                case 9: {
                    this.order.phone = text;
                }
            }
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.searchEntry.func_230999_j_()) {
            boolean flag = this.searchEntry.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
            this.updateList();
            return flag;
        }
        if (this.focusedField != null) {
            if (this.focusedField.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
                int id = this.focusedField.getId();
                String text = this.focusedField.func_146179_b().trim();
                switch (id) {
                    case 0: {
                        this.order.emailAddress = text;
                        break;
                    }
                    case 1: {
                        this.order.password = text;
                        break;
                    }
                    case 2: {
                        this.order.firstName = text;
                        break;
                    }
                    case 3: {
                        this.order.lastName = text;
                        break;
                    }
                    case 4: {
                        this.order.address = text;
                        break;
                    }
                    case 5: {
                        this.order.city = text;
                        break;
                    }
                    case 6: {
                        this.order.zip = text;
                        break;
                    }
                    case 7: {
                        this.order.state = text;
                        break;
                    }
                    case 8: {
                        this.order.country = text;
                        break;
                    }
                    case 9: {
                        this.order.phone = text;
                    }
                }
                return true;
            }
            if (p_keyPressed_1_ == 258) {
                TextFieldDetails field = this.focusedField;
                int adjustAm = 1;
                int fieldsSize = this.fields.size();
                field.func_230996_d_(false);
                int newField = (field.getId() + adjustAm) % fieldsSize;
                if (newField == -1) {
                    newField = fieldsSize - 1;
                }
                TextFieldDetails newF = null;
                while (newF == null) {
                    TextFieldDetails tempField = this.fields.get(newField);
                    if (tempField.canBeFocused()) {
                        newF = tempField;
                        continue;
                    }
                    if ((newField = (newField + adjustAm) % fieldsSize) != -1) continue;
                    newField = fieldsSize - 1;
                }
                newF.func_230996_d_(true);
            }
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        int info2Start = this.field_230709_l_ / 2 - 50;
        if (this.orderPressed && !this.isSure && mouseY >= (double)info2Start) {
            ITextComponent comp;
            ClickEvent clickevent;
            Objects.requireNonNull(this.field_230712_o_);
            if (mouseY <= (double)(info2Start + 9) && (clickevent = (comp = this.getComponent(mouseX, mouseY)).func_150256_b().func_150235_h()) != null && clickevent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                try {
                    URI uri = new URI(clickevent.func_150668_b());
                    Class<?> oclass = Class.forName("java.awt.Desktop");
                    Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    oclass.getMethod("browse", URI.class).invoke(object, uri);
                    return true;
                }
                catch (Throwable t) {
                    MineTogether.logger.error("Can't open url for " + clickevent, t);
                    return false;
                }
            }
        }
        for (TextFieldDetails field : this.fields) {
            if (!field.func_231044_a_(mouseX, mouseY, mouseButton)) continue;
            if (this.focusedField != null) {
                this.focusedField.func_230996_d_(false);
            }
            this.focusedField = field;
            field.func_230996_d_(true);
            return true;
        }
        return false;
    }

    private ITextComponent getComponent(double mouseX, double mouseY) {
        int stringWidth = this.field_230712_o_.func_78256_a(this.info2.getString());
        int begin = this.field_230708_k_ / 2 - stringWidth / 2;
        if (this.info2 instanceof TranslationTextComponent) {
            TranslationTextComponent comp = (TranslationTextComponent)this.info2;
            int prevWidth = begin;
            for (ITextComponent inner : comp.func_150253_a()) {
                StringBuilder stringbuilder = new StringBuilder();
                String s2 = inner.getString();
                if (!s2.isEmpty()) {
                    stringbuilder.append(inner.func_150256_b());
                    stringbuilder.append(s2);
                    stringbuilder.append(TextFormatting.RESET);
                }
                int width = this.field_230712_o_.func_78256_a(stringbuilder.toString());
                if (mouseX >= (double)prevWidth && mouseX <= (double)(prevWidth + width)) {
                    return inner;
                }
                prevWidth += width;
            }
        }
        return null;
    }

    public void validationChanged(TextFieldDetails details, boolean valid, IOrderValidation validator, IOrderValidation.ValidationPhase phase) {
        if (details.getId() == 0) {
            if (!valid && validator.getName().equals("NotEmailExistsValidator") && !validator.isAsync()) {
                this.isEmailValid = false;
                this.loginMode = true;
            } else {
                this.loginMode = false;
                this.isEmailValid = phase.equals((Object)IOrderValidation.ValidationPhase.FOCUSLOST);
            }
        }
    }

    public void validationChangedDeferred(TextFieldDetails textFieldDetails, DefferedValidation pendingValidation) {
        if (!pendingValidation.isValid("")) {
            this.validationChanged(textFieldDetails, false, pendingValidation, pendingValidation.getPhase());
        } else {
            this.validationChanged(textFieldDetails, true, null, pendingValidation.getPhase());
        }
    }

    public void updateList() {
        this.first = false;
        this.list.clearList();
        Map<String, String> locations = ServerOrderCallbacks.getCountries();
        for (Map.Entry<String, String> entry : locations.entrySet()) {
            if (!this.searchEntry.func_146179_b().isEmpty() && !entry.getValue().toLowerCase().contains(this.searchEntry.func_146179_b().toLowerCase())) continue;
            ListEntryCountry listEntry = new ListEntryCountry(this.list, entry.getKey(), entry.getValue());
            this.list.add(listEntry);
            if (!this.order.country.equals(listEntry.countryID)) continue;
            this.list.func_241215_a_(listEntry);
        }
    }
}

