/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.module.serverorder.screen.GeneralServerInfoScreen;
import net.creeperhost.minetogether.module.serverorder.screen.MapScreen;
import net.creeperhost.minetogether.module.serverorder.screen.OrderDetailsScreen;
import net.creeperhost.minetogether.module.serverorder.screen.PersonalDetailsScreen;
import net.creeperhost.minetogether.module.serverorder.screen.QuoteScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class OrderServerScreen
extends Screen {
    private static final int STEP_AMOUNT = 5;
    protected final int stepId;
    protected final Order order;
    protected Button buttonPrev;
    protected Button buttonNext;
    protected Button buttonCancel;
    private Screen parent;

    public OrderServerScreen(int stepId, Screen parent, Order order) {
        super((ITextComponent)new TranslationTextComponent("minetogether.screen.orderscreen"));
        this.stepId = stepId;
        this.order = order;
        this.parent = parent;
    }

    public OrderServerScreen(int stepId, Order order) {
        super((ITextComponent)new TranslationTextComponent("minetogether.screen.orderscreen"));
        this.stepId = stepId;
        this.order = order;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.addNavigationButtons();
    }

    public void addNavigationButtons() {
        this.buttonPrev = new Button(10, this.field_230709_l_ - 30, 80, 20, (ITextComponent)new TranslationTextComponent("minetogether.button.prev"), button -> this.field_230706_i_.func_147108_a(OrderServerScreen.getByStep(this.stepId - 1, this.order, this.parent)));
        this.func_230480_a_((Widget)this.buttonPrev);
        this.buttonCancel = new Button(this.field_230708_k_ / 2 - 40, this.field_230709_l_ - 30, 80, 20, (ITextComponent)new TranslationTextComponent("minetogether.button.cancel"), button -> this.cancelOrder());
        this.func_230480_a_((Widget)this.buttonCancel);
        this.buttonNext = new Button(this.field_230708_k_ - 90, this.field_230709_l_ - 30, 80, 20, (ITextComponent)new TranslationTextComponent("minetogether.button.next"), button -> {
            if (this.stepId + 1 == 5) {
                this.field_230706_i_.func_147108_a(this.parent);
            } else {
                this.field_230706_i_.func_147108_a(OrderServerScreen.getByStep(this.stepId + 1, this.order, this.parent));
            }
        });
        this.func_230480_a_((Widget)this.buttonNext);
        this.buttonPrev.field_230693_o_ = this.stepId > 0;
    }

    public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
        OrderServerScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)("Step " + (this.stepId + 1) + " / " + 5), (int)(this.field_230708_k_ - 30), (int)10, (int)-1);
        OrderServerScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.getStepName(), (int)(this.field_230708_k_ / 2), (int)10, (int)-1);
        super.func_230430_a_(poseStack, i, j, f);
    }

    public static Screen getByStep(int step, Order order, Screen parent) {
        switch (step) {
            default: {
                return new GeneralServerInfoScreen(0, order, parent);
            }
            case 1: {
                return new MapScreen(1, order);
            }
            case 2: {
                return new PersonalDetailsScreen(2, order);
            }
            case 3: {
                return new QuoteScreen(3, order);
            }
            case 4: 
        }
        return new OrderDetailsScreen(4, order);
    }

    public abstract String getStepName();

    public void cancelOrder() {
        this.field_230706_i_.func_147108_a(null);
    }
}

