/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.util.LimitedSizeQueue;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.creeperhost.minetogether.util.ComponentUtils;
import net.creeperhost.minetogethergui.gif.AnimatedGif;
import net.creeperhost.minetogethergui.gif.ImageRenderer;
import net.creeperhost.minetogethergui.gif.ImageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;

public class ScrollingChat
extends ExtendedList {
    private ArrayList<IReorderingProcessor> lines;
    private final int height;
    private final int top;
    private final int bottom;
    private final int itemHeight;
    private final MineTogetherScreen screen;
    private final int chatOffset;
    private final boolean renderBackground;
    private AnimatedGif gifImage;
    private AnimatedGif.GifPlayer gifPlayer;
    private ImageRenderer.Image image;
    private ImageRenderer imageRenderer;

    public ScrollingChat(MineTogetherScreen screen, int width, int height, int chatOffset) {
        super(Minecraft.func_71410_x(), width - 20, height - 50, 30, height - 50, 10);
        this.height = height - 50;
        this.field_230670_d_ = width - 20;
        this.top = 30;
        this.bottom = height - 50;
        this.itemHeight = 10;
        this.chatOffset = chatOffset;
        this.screen = screen;
        this.lines = new ArrayList();
        this.renderBackground = true;
    }

    public ScrollingChat(MineTogetherScreen screen, int widthIn, int heightIn, int topIn, int bottomIn, int chatOffset, boolean renderBackground) {
        super(Minecraft.func_71410_x(), widthIn, heightIn, topIn, bottomIn, 10);
        this.height = heightIn;
        this.field_230670_d_ = widthIn;
        this.top = 30;
        this.bottom = this.height;
        this.itemHeight = 10;
        this.screen = screen;
        this.lines = new ArrayList();
        this.chatOffset = chatOffset;
        this.renderBackground = renderBackground;
    }

    public void renderEntry(MatrixStack poseStack, int index, int mouseX, int mouseY, float partialTicks) {
        try {
            int totalWidth;
            IReorderingProcessor component = this.lines.get(index);
            int oldTotal = totalWidth = this.chatOffset;
            boolean hovering = mouseX > oldTotal && mouseX < (totalWidth += this.field_230668_b_.field_71466_p.func_243245_a(component)) && mouseY > this.func_230962_i_(index) && mouseY < this.func_230962_i_(index) + this.itemHeight;
            Style style = this.field_230668_b_.field_71466_p.func_238420_b_().func_243239_a(component, mouseX);
            if (hovering) {
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                this.field_230668_b_.field_71466_p.func_238422_b_(poseStack, component, (float)oldTotal, (float)this.func_230962_i_(index), -1140850689);
                this.screen.func_238653_a_(poseStack, style, mouseX, mouseY);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (style.func_150210_i() != null && style.func_150210_i().func_150701_a() == ComponentUtils.RENDER_GIF) {
                    ITextComponent urlComponent = (ITextComponent)style.func_150210_i().func_240662_a_(ComponentUtils.RENDER_GIF);
                    String url = urlComponent.getString();
                    if (ImageUtils.getContentType(new URL(url)).equals("image/gif")) {
                        if (this.gifImage == null) {
                            CompletableFuture.runAsync(() -> {
                                try {
                                    this.gifImage = AnimatedGif.fromURL(new URL(url));
                                }
                                catch (IOException exception) {
                                    exception.printStackTrace();
                                }
                            }, AnimatedGif.GIF_EXECUTOR);
                        }
                        if (this.gifPlayer == null) {
                            this.gifPlayer = this.gifImage.makeGifPlayer();
                            this.gifPlayer.setAutoplay(true);
                            this.gifPlayer.setLooping(true);
                        }
                    } else {
                        if (this.image == null) {
                            CompletableFuture.runAsync(() -> {
                                try {
                                    this.image = ImageRenderer.fromURL(new URL(url));
                                }
                                catch (IOException exception) {
                                    exception.printStackTrace();
                                }
                            }, AnimatedGif.GIF_EXECUTOR);
                        }
                        if (this.image != null && this.imageRenderer == null) {
                            this.imageRenderer = new ImageRenderer(this.image);
                        }
                    }
                } else {
                    this.imageRenderer = null;
                    this.image = null;
                    this.gifImage = null;
                    this.gifPlayer = null;
                }
            } else {
                this.field_230668_b_.field_71466_p.func_238422_b_(poseStack, component, (float)oldTotal, (float)this.func_230962_i_(index), 0xFFFFFF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int func_230965_k_() {
        return this.lines.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLines(String key) {
        LimitedSizeQueue<Message> tempMessages;
        int oldMaxScroll = this.func_230955_e_();
        Object object = ChatHandler.ircLock;
        synchronized (object) {
            if (ChatHandler.messages == null || ChatHandler.messages.size() == 0) {
                return;
            }
            tempMessages = ChatHandler.messages.get(key);
        }
        ArrayList<IReorderingProcessor> oldLines = this.lines;
        int listHeight = this.height - (this.bottom - this.top - 4);
        this.lines = new ArrayList();
        if (tempMessages == null) {
            return;
        }
        try {
            for (Message message : tempMessages) {
                ITextComponent display = ChatFormatter.formatLine(message);
                if (display == null) continue;
                this.lines.addAll(RenderComponentsUtil.func_238505_a_((ITextProperties)display, (int)(this.field_230670_d_ - 10), (FontRenderer)Minecraft.func_71410_x().field_71466_p));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.lines.size() <= oldLines.size() || this.func_230966_l_() == (double)oldMaxScroll) {
            // empty if block
        }
        this.func_230932_a_(this.func_230955_e_());
    }

    private int getRowBottom(int p_getRowBottom_1_) {
        return this.func_230962_i_(p_getRowBottom_1_) + this.itemHeight;
    }

    protected boolean func_230957_f_(int i) {
        return false;
    }

    protected int func_230952_d_() {
        return 0;
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.renderBackground) {
            this.func_230433_a_(poseStack);
        }
        int i = this.func_230952_d_();
        int j = i + 6;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.renderBackground) {
            this.field_230668_b_.func_110434_K().func_110577_a(AbstractGui.field_230663_f_);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225583_a_((float)this.field_230675_l_ / 32.0f, (float)(this.field_230673_j_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225583_a_((float)this.field_230674_k_ / 32.0f, (float)(this.field_230673_j_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225583_a_((float)this.field_230674_k_ / 32.0f, (float)(this.field_230672_i_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225583_a_((float)this.field_230675_l_ / 32.0f, (float)(this.field_230672_i_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        int k = this.func_230968_n_();
        int l = this.field_230672_i_ + 4 - (int)this.func_230966_l_();
        this.func_238478_a_(poseStack, k, l, mouseX, mouseY, partialTicks);
        if (this.renderBackground) {
            this.field_230668_b_.func_110434_K().func_110577_a(AbstractGui.field_230663_f_);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            float f1 = 32.0f;
            int i1 = -100;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, -100.0).func_225583_a_(0.0f, (float)this.field_230672_i_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230672_i_, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.field_230672_i_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), 0.0, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, 0.0, -100.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.height, -100.0).func_225583_a_(0.0f, (float)this.height / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.height, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.height / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230673_j_, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.field_230673_j_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, -100.0).func_225583_a_(0.0f, (float)this.field_230673_j_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        int j1 = 4;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)(this.field_230672_i_ + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)(this.field_230672_i_ + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230674_k_, (double)(this.field_230673_j_ - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230675_l_, (double)(this.field_230673_j_ - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        this.func_230447_a_(poseStack, mouseX, mouseY);
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        if (this.gifPlayer != null && this.gifImage != null) {
            this.gifPlayer.render(poseStack, mouseX + 5, mouseY + 5, 80, 60, partialTicks);
        }
        if (this.imageRenderer != null) {
            this.imageRenderer.render(poseStack, mouseX + 5, mouseY + 5, 80, 60, partialTicks);
        }
    }

    public void tick() {
        if (this.gifPlayer != null) {
            this.gifPlayer.tick();
        }
    }

    public int func_230962_i_(int i) {
        return super.func_230962_i_(i);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.field_230670_d_;
    }

    public int getTop() {
        return this.top;
    }

    protected void func_238478_a_(MatrixStack poseStack, int p_renderList_1_, int p_renderList_2_, int mouseX, int mouseY, float p_renderList_5_) {
        int i = this.lines.size();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (!this.lines.isEmpty()) {
            for (int j = 0; j < i; ++j) {
                int k = this.func_230962_i_(j);
                int l = this.getRowBottom(j);
                if (l < this.field_230672_i_ || k > this.field_230673_j_) continue;
                int i1 = p_renderList_2_ + j * this.itemHeight + this.field_230677_n_;
                int j1 = this.itemHeight - 4;
                int k1 = this.func_230949_c_();
                if (this.func_230957_f_(j)) {
                    int l1 = this.field_230675_l_ + this.field_230670_d_ / 2 - k1 / 2;
                    int i2 = this.field_230675_l_ + this.field_230670_d_ / 2 + k1 / 2;
                    RenderSystem.disableTexture();
                    float f = this.func_230971_aw__() ? 1.0f : 0.5f;
                    RenderSystem.color4f((float)f, (float)f, (float)f, (float)1.0f);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                    bufferbuilder.func_225582_a_((double)l1, (double)(i1 + j1 + 2), 0.0).func_181675_d();
                    bufferbuilder.func_225582_a_((double)i2, (double)(i1 + j1 + 2), 0.0).func_181675_d();
                    bufferbuilder.func_225582_a_((double)i2, (double)(i1 - 2), 0.0).func_181675_d();
                    bufferbuilder.func_225582_a_((double)l1, (double)(i1 - 2), 0.0).func_181675_d();
                    tessellator.func_78381_a();
                    RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                    bufferbuilder.func_225582_a_((double)(l1 + 1), (double)(i1 + j1 + 1), 0.0).func_181675_d();
                    bufferbuilder.func_225582_a_((double)(i2 - 1), (double)(i1 + j1 + 1), 0.0).func_181675_d();
                    bufferbuilder.func_225582_a_((double)(i2 - 1), (double)(i1 - 1), 0.0).func_181675_d();
                    bufferbuilder.func_225582_a_((double)(l1 + 1), (double)(i1 - 1), 0.0).func_181675_d();
                    tessellator.func_78381_a();
                    RenderSystem.enableTexture();
                }
                this.renderEntry(poseStack, j, mouseX, mouseY, p_renderList_5_);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int p_mouseClicked_5_) {
        for (int i = 0; i < this.lines.size(); ++i) {
            boolean hovering;
            int totalWidth;
            IReorderingProcessor component = this.lines.get(i);
            int oldTotal = totalWidth = 5;
            boolean bl = hovering = mouseX > (double)oldTotal && mouseX < (double)(totalWidth += this.field_230668_b_.field_71466_p.func_243245_a(component)) && mouseY > (double)this.func_230962_i_(i) && mouseY < (double)(this.func_230962_i_(i) + this.itemHeight);
            if (!hovering) continue;
            Style style = this.field_230668_b_.field_71466_p.func_238420_b_().func_243239_a(component, (int)mouseX);
            this.screen.handleComponentClicked(style, mouseX, mouseY);
            return true;
        }
        return false;
    }
}

