/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.util.ComponentUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class ChatFormatter {
    private static final Pattern nameRegex = Pattern.compile("^(\\w+?):");
    private static final Pattern patternA = Pattern.compile("((?:user)([a-zA-Z0-9]+))", 10);
    private static final Pattern patternB = Pattern.compile("((?:@)([a-zA-Z0-9]+))", 10);
    private static final Pattern patternC = Pattern.compile("((?:@user)([a-zA-Z0-9]+))", 10);
    private static final Pattern patternD = Pattern.compile("((?:@user)#([a-zA-Z0-9]+))", 10);
    private static final Pattern patternE = Pattern.compile("((?:user)#([a-zA-Z0-9]+))", 10);
    private static final Pattern patternF = Pattern.compile("([a-zA-Z0-9]+)#([a-zA-Z0-9]+)", 10);
    private static final Pattern patternG = Pattern.compile("(@[a-zA-Z0-9]+)#([a-zA-Z0-9]+)", 10);

    public static ITextComponent formatLine(Message message) {
        try {
            String inputNick;
            String outputNick = inputNick = message.sender;
            if (inputNick.contains(":")) {
                String[] split = inputNick.split(":");
                switch (split[0]) {
                    case "FR": {
                        if (split.length < 2) {
                            return null;
                        }
                        String nick = split[1];
                        Profile profile = KnownUsers.findByNick(nick);
                        if (profile == null) {
                            profile = KnownUsers.add(nick);
                        }
                        String nickDisplay = profile.isFriend() ? profile.getFriendName() : profile.getUserDisplay();
                        String cmdStr = message.messageStr;
                        String[] cmdSplit = cmdStr.split(" ");
                        if (cmdSplit.length < 2) {
                            return null;
                        }
                        String friendCode = cmdSplit[0];
                        StringBuilder nameBuilder = new StringBuilder();
                        for (int i = 1; i < cmdSplit.length; ++i) {
                            nameBuilder.append(cmdSplit[i]);
                        }
                        String friendName = nameBuilder.toString();
                        TranslationTextComponent userComp = new TranslationTextComponent("(" + nickDisplay + ") would like to add you as a friend. Click to ");
                        TranslationTextComponent accept = new TranslationTextComponent("<Accept>");
                        accept = accept.func_230532_e_().func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "AC:" + nick + ":" + friendCode + ":" + friendName)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN)));
                        userComp.func_150253_a().add(accept);
                        return userComp;
                    }
                    case "FA": {
                        if (split.length < 2) {
                            return null;
                        }
                        String nick = split[1];
                        Profile profile = KnownUsers.findByNick(nick);
                        if (profile == null) {
                            profile = KnownUsers.add(nick);
                        }
                        String nickDisplay = profile.isFriend() ? profile.getFriendName() : profile.getUserDisplay();
                        TranslationTextComponent userComp = new TranslationTextComponent(" (" + nickDisplay + ") accepted your friend request.");
                        return userComp;
                    }
                }
            }
            AtomicBoolean premium = new AtomicBoolean(false);
            Profile profile = null;
            if (inputNick.startsWith("MT") && inputNick.length() >= 16) {
                profile = KnownUsers.findByNick(inputNick);
                if (profile == null) {
                    profile = KnownUsers.add(inputNick);
                }
                if (profile != null) {
                    premium.set(profile.isPremium());
                    outputNick = profile.getUserDisplay();
                }
                if (inputNick.equals(MineTogetherChat.profile.get().getShortHash()) || inputNick.equals(MineTogetherChat.profile.get().getMediumHash())) {
                    outputNick = MineTogetherChat.profile.get().getUserDisplay();
                } else if (profile.isMuted()) {
                    return null;
                }
            } else if (!inputNick.equals("System")) {
                return null;
            }
            TranslationTextComponent base = new TranslationTextComponent("");
            TextFormatting nickColour = TextFormatting.WHITE;
            TextFormatting arrowColour = TextFormatting.WHITE;
            TextFormatting messageColour = TextFormatting.WHITE;
            if (profile != null && profile.isFriend()) {
                nickColour = TextFormatting.YELLOW;
                outputNick = profile.friendName;
                if (!ChatHandler.autocompleteNames.contains(outputNick)) {
                    ChatHandler.autocompleteNames.add(outputNick);
                }
            }
            TranslationTextComponent userComp = new TranslationTextComponent(outputNick);
            String messageStr = message.messageStr;
            CharSequence[] split = messageStr.split(" ");
            boolean highlight = false;
            for (int i = 0; i < split.length; ++i) {
                String splitStr = split[i];
                String justNick = splitStr.replaceAll("[^A-Za-z0-9#]", "");
                if (!justNick.startsWith("MT") || justNick.length() < 16) continue;
                if (MineTogetherChat.profile.get() != null && (justNick.equals(MineTogetherChat.profile.get().getShortHash()) || justNick.equals(MineTogetherChat.profile.get().getMediumHash())) || justNick.equals(MineTogetherChat.INSTANCE.ourNick)) {
                    splitStr = splitStr.replaceAll(justNick, TextFormatting.RED + Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString() + messageColour);
                    split[i] = splitStr;
                    highlight = true;
                    continue;
                }
                if (justNick.length() < 16) continue;
                String userName = "User#" + justNick.substring(2, 5);
                Profile mentionProfile = KnownUsers.findByNick(justNick);
                if (mentionProfile != null) {
                    userName = mentionProfile.getUserDisplay();
                }
                if (userName == null) continue;
                splitStr = splitStr.replaceAll(justNick, userName);
                split[i] = splitStr;
            }
            messageStr = String.join((CharSequence)" ", split);
            ITextComponent messageComp = ChatFormatter.newChatWithLinksOurs(messageStr);
            if (profile != null && profile.isBanned() || ChatHandler.backupBan.get().contains(inputNick)) {
                messageComp = new TranslationTextComponent(TextFormatting.OBFUSCATED + "<Message Deleted>").func_230532_e_().func_240700_a_(style -> style.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GRAY)));
                messageColour = TextFormatting.DARK_GRAY;
            }
            messageComp.func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.WHITE));
            if (profile != null && !profile.getPackID().isEmpty() && ChatFormatter.profilePackMatcher(profile)) {
                nickColour = TextFormatting.DARK_PURPLE;
                if (profile.isFriend()) {
                    nickColour = TextFormatting.GOLD;
                }
            }
            if (inputNick.equals(MineTogetherChat.INSTANCE.ourNick)) {
                nickColour = TextFormatting.GRAY;
                arrowColour = premium.get() ? TextFormatting.GREEN : TextFormatting.GRAY;
                messageColour = TextFormatting.GRAY;
                outputNick = MineTogetherChat.profile.get().getUserDisplay();
                userComp = new TranslationTextComponent(outputNick);
            }
            if (premium.get()) {
                arrowColour = TextFormatting.GREEN;
            } else if (outputNick.equals("System")) {
                Matcher matcher = nameRegex.matcher(messageStr);
                if (matcher.find()) {
                    outputNick = matcher.group();
                    messageStr = messageStr.substring(outputNick.length() + 1);
                    outputNick = outputNick.substring(0, outputNick.length() - 1);
                    messageComp = ChatFormatter.newChatWithLinksOurs(messageStr);
                    userComp = new TranslationTextComponent(outputNick);
                }
                nickColour = TextFormatting.AQUA;
            }
            userComp = new TranslationTextComponent(arrowColour + "<" + nickColour + userComp.getString() + arrowColour + "> ");
            if (!inputNick.equals(MineTogetherChat.INSTANCE.ourNick) && inputNick.startsWith("MT")) {
                String finalOutputNick = outputNick;
                userComp = userComp.func_230532_e_().func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, finalOutputNick)));
            }
            TextFormatting finalMessageColour = messageColour;
            messageComp = messageComp.func_230532_e_().func_240700_a_(style -> style.func_240718_a_(Color.func_240744_a_((TextFormatting)finalMessageColour)));
            if (Config.getInstance().getFirstConnect()) {
                messageComp = new TranslationTextComponent(messageComp.getString());
                messageComp = messageComp.func_230532_e_().func_240700_a_(style -> style.func_240719_a_(Constants.GALACTIC_ALT_FONT));
            }
            base.func_150253_a().add(userComp);
            base.func_150253_a().add(messageComp);
            return base;
        }
        catch (Throwable e) {
            MineTogether.logger.error("Failed to format line: Sender " + message.sender + " Message" + message.messageStr);
            e.printStackTrace();
            return new TranslationTextComponent("Error formatting line, Please report this to the issue tracker");
        }
    }

    public static String rot13(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean profilePackMatcher(Profile profile) {
        if (profile == null) {
            return false;
        }
        if (profile.getPackID().isEmpty()) {
            return false;
        }
        if (MineTogetherChat.profile.get().getPackID().isEmpty()) {
            return false;
        }
        String profilePack = ChatFormatter.getCleanedPackID(profile);
        String ourID = ChatFormatter.getCleanedPackID(MineTogetherChat.profile.get());
        if (profilePack.isEmpty()) {
            return false;
        }
        if (ourID.isEmpty()) {
            return false;
        }
        return profilePack.equals(ourID);
    }

    public static String getCleanedPackID(Profile profile) {
        if (profile == null) {
            return "";
        }
        String json = profile.getPackID();
        JsonElement jElement = new JsonParser().parse(json);
        JsonObject jObject = jElement.getAsJsonObject();
        String id = jObject.get("p").getAsString();
        if (id == null) {
            return "";
        }
        return id;
    }

    public static String getStringForSending(String text) {
        CharSequence[] split = text.split(" ");
        boolean replaced = false;
        for (int i = 0; i < split.length; ++i) {
            Profile profile;
            String word = split[i].toLowerCase();
            String subst = "User#$2";
            String substr2 = "$1#$2";
            Matcher matcher = patternA.matcher(word);
            Matcher matcherb = patternB.matcher(word);
            Matcher matcherc = patternC.matcher(word);
            Matcher matcherd = patternD.matcher(word);
            Matcher matchere = patternE.matcher(word);
            Matcher matcherf = patternF.matcher(word);
            Matcher matcherg = patternG.matcher(word);
            String justNick = word;
            String result = word;
            String result2 = "";
            if (matcher.matches()) {
                result = matcher.replaceAll("User#$2");
            } else if (matcherb.matches()) {
                result = matcherb.replaceAll("User#$2");
            } else if (matcherc.matches()) {
                result = matcherc.replaceAll("User#$2");
            } else if (matcherd.matches()) {
                result = matcherd.replaceAll("User#$2");
            } else if (matchere.matches()) {
                result = matchere.replaceAll("User#$2");
            } else if (matcherg.matches()) {
                result2 = matcherg.replaceAll("$1#$2");
            } else if (matcherf.matches()) {
                result2 = matcherf.replaceAll("$1#$2");
            }
            if (!result.startsWith("User") && result2.length() <= 0 || (profile = KnownUsers.findByDisplay(justNick = result2.length() > 0 ? result2.replaceAll("[^A-Za-z0-9#]", "") : result.replaceAll("[^A-Za-z0-9#]", ""))) == null) continue;
            String tempWord = profile.getShortHash();
            if (tempWord != null) {
                split[i] = result.replaceAll(justNick, tempWord);
                replaced = true;
                continue;
            }
            if (!justNick.toLowerCase().equals(Minecraft.func_71410_x().func_110432_I().func_111285_a())) continue;
            split[i] = result.replaceAll(justNick, MineTogetherChat.INSTANCE.ourNick);
            replaced = true;
        }
        if (replaced) {
            text = String.join((CharSequence)" ", split);
        }
        return text;
    }

    public static ITextComponent newChatWithLinksOurs(String string) {
        ITextComponent component = ComponentUtils.newChatWithLinks(string, true);
        if (component.func_150256_b().func_150235_h() != null) {
            ITextComponent oldcomponent = component;
            List siblings = oldcomponent.func_150253_a();
            component = new TranslationTextComponent("");
            component.func_150253_a().add(oldcomponent);
            for (ITextComponent sibling : siblings) {
                component.func_150253_a().add(sibling);
            }
            siblings.clear();
        }
        return component;
    }
}

