/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin;

import com.mojang.authlib.GameProfile;
import java.net.SocketAddress;
import java.util.List;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.connect.ConnectHelper;
import net.creeperhost.minetogether.module.connect.OurServerListEntryLanDetected;
import net.creeperhost.minetogetherconnect.ConnectMain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerList {
    @Shadow
    @Final
    private MinecraftServer field_72400_f;
    @Shadow
    @Final
    private List<ServerPlayerEntity> field_72404_b;
    private static final ITextComponent NOT_FRIEND_COMPONENT = new TranslationTextComponent("minetogether.connect.join.notfriend");

    @Shadow
    public abstract int func_72352_l();

    @Inject(at={@At(value="RETURN")}, method={"getMaxPlayers()I"}, cancellable=true)
    private void getMaxPlayers(CallbackInfoReturnable<Integer> cir) {
        if (ConnectHelper.isShared(this.field_72400_f)) {
            cir.setReturnValue((Object)ConnectMain.maxPlayerCount);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"}, cancellable=true)
    private void canPlayerJoinHook(SocketAddress socket, GameProfile profile, CallbackInfoReturnable<ITextComponent> cir) {
        if (ConnectHelper.isShared(this.field_72400_f)) {
            boolean isFriend;
            String playerHash = ChatCallbacks.getPlayerHash(profile.getId());
            Profile byHash = KnownUsers.findByHash(playerHash);
            boolean bl = isFriend = byHash == null || !byHash.isFriend();
            if (isFriend) {
                cir.setReturnValue((Object)NOT_FRIEND_COMPONENT);
            } else if (this.field_72404_b.size() >= this.func_72352_l()) {
                cir.setReturnValue((Object)OurServerListEntryLanDetected.FULL_MESSAGE_COMPONENT);
                ITextComponent component = ChatFormatter.newChatWithLinksOurs(I18n.func_135052_a((String)"minetogether.connect.join.tried.name", (Object[])new Object[]{byHash.getUserDisplay(), ConnectMain.maxPlayerCount}));
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(component);
            }
        }
    }
}

