/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.util;

public final class Util {

    public static class CachedValue<T> {
        private long invalidTime;
        private ICacheCallback<T> callback;
        private T cachedValue;
        private long validTime;
        private static final Object lock = new Object();

        public CachedValue(int validTime, ICacheCallback<T> callback) {
            this.validTime = validTime;
            this.invalidTime = System.currentTimeMillis() + (long)validTime;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get(Object ... args) {
            if (System.currentTimeMillis() < this.invalidTime && !this.callback.needsRefresh(args) && this.cachedValue != null) {
                return this.cachedValue;
            }
            Object object = lock;
            synchronized (object) {
                T temp = this.callback.get(args);
                if (temp != null) {
                    this.cachedValue = temp;
                }
            }
            this.invalidTime = this.validTime + System.currentTimeMillis();
            return this.cachedValue;
        }

        public void set(T newCachedValue) {
            this.invalidTime = this.validTime + System.currentTimeMillis();
            this.cachedValue = newCachedValue;
        }

        public T getCachedValue(Object ... args) {
            return this.cachedValue;
        }

        public static interface ICacheCallback<T> {
            public T get(Object ... var1);

            public boolean needsRefresh(Object ... var1);
        }
    }
}

