/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.serverorder;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.serverorder.AvailableResult;
import net.creeperhost.minetogether.lib.serverorder.OrderSummary;
import net.creeperhost.minetogether.lib.util.WebUtils;

public class ServerOrderCallbacks {
    private static String userCountry;
    private static Map<String, String> countries;

    public static Map<String, String> getCountries() {
        return countries;
    }

    public static AvailableResult getNameAvailable(String name) {
        try {
            String result = WebUtils.getWebResponse("https://www.creeperhost.net/json/availability/" + name);
            JsonElement jElement = new JsonParser().parse(result);
            JsonObject jObject = jElement.getAsJsonObject();
            String status = jObject.getAsJsonPrimitive("status").getAsString();
            boolean statusBool = status.equals("success");
            String message = jObject.getAsJsonPrimitive("message").getAsString();
            return new AvailableResult(statusBool, message);
        }
        catch (Throwable t) {
            MineTogetherChat.logger.error("Unable to check if name available", t);
            return new AvailableResult(false, "unknown");
        }
    }

    public static OrderSummary getSummary(Order order, String modpackVersion, String promo) {
        if (order.country.isEmpty()) {
            order.country = ServerOrderCallbacks.getUserCountry();
        }
        if (order.serverLocation.isEmpty()) {
            order.serverLocation = ServerOrderCallbacks.getRecommendedLocation();
        }
        try {
            double discount;
            String version = modpackVersion;
            if (version.equals("0")) {
                // empty if block
            }
            String url = "https://www.creeperhost.net/json/order/mc/" + version + "/recommend/" + order.playerAmount;
            String resp = WebUtils.getWebResponse(url);
            JsonElement jElement = new JsonParser().parse(resp);
            JsonObject jObject = jElement.getAsJsonObject();
            String recommended = jObject.getAsJsonPrimitive("recommended").getAsString();
            if (!promo.isEmpty() && !promo.equalsIgnoreCase("Insert Promo Code here")) {
                WebUtils.getWebResponse("https://www.creeperhost.net/applyPromo/" + promo);
            }
            String summary = WebUtils.getWebResponse("https://www.creeperhost.net/json/order/" + order.country + "/" + recommended + "/summary");
            jElement = new JsonParser().parse(summary);
            jObject = jElement.getAsJsonObject();
            jObject = jObject.getAsJsonObject("0");
            double preDiscount = jObject.getAsJsonPrimitive("PreDiscount").getAsDouble();
            double subTotal = jObject.getAsJsonPrimitive("Subtotal").getAsDouble();
            try {
                discount = jObject.getAsJsonPrimitive("Discount").getAsDouble();
            }
            catch (Exception e) {
                discount = 0.0;
            }
            double tax = jObject.getAsJsonPrimitive("Tax").getAsDouble();
            if (tax <= 0.0) {
                tax = 0.0;
            }
            double total = jObject.getAsJsonPrimitive("Total").getAsDouble();
            String currency = WebUtils.getWebResponse("https://www.creeperhost.net/json/currency/" + order.country);
            jElement = new JsonParser().parse(currency);
            jObject = jElement.getAsJsonObject();
            String prefix = jObject.getAsJsonPrimitive("prefix").getAsString();
            String suffix = jObject.getAsJsonPrimitive("suffix").getAsString();
            String id = jObject.getAsJsonPrimitive("id").getAsString();
            String product = WebUtils.getWebResponse("https://www.creeperhost.net/json/products/" + recommended);
            jElement = new JsonParser().parse(product);
            jObject = jElement.getAsJsonObject();
            String vpsDisplay = jObject.getAsJsonPrimitive("displayName").getAsString();
            String vpsDescription = jObject.getAsJsonPrimitive("description").getAsString();
            String patternStr = "<li>(.*?)<";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(vpsDescription);
            ArrayList<String> vpsFeatures = new ArrayList<String>();
            while (matcher.find()) {
                String group = matcher.group(1);
                vpsFeatures.add(group);
            }
            ArrayList<String> vpsIncluded = new ArrayList<String>();
            vpsIncluded.add("minetogether.quote.vpsincluded1");
            vpsIncluded.add("minetogether.quote.vpsincluded2");
            vpsIncluded.add("minetogether.quote.vpsincluded3");
            vpsIncluded.add("minetogether.quote.vpsincluded4");
            vpsIncluded.add("minetogether.quote.vpsincluded5");
            vpsIncluded.add("minetogether.quote.vpsincluded6");
            vpsIncluded.add("minetogether.quote.vpsincluded7");
            return new OrderSummary(recommended, vpsDisplay, vpsFeatures, vpsIncluded, preDiscount, subTotal, total, tax, discount, suffix, prefix, id);
        }
        catch (Throwable t) {
            MineTogetherChat.logger.error("Unable to fetch summary", t);
            return null;
        }
    }

    public static String getRecommendedLocation() {
        try {
            String freeGeoIP = WebUtils.getWebResponse("https://www.creeperhost.net/json/datacentre/closest");
            JsonObject jObject = new JsonParser().parse(freeGeoIP).getAsJsonObject();
            jObject = jObject.getAsJsonObject("datacentre");
            return jObject.getAsJsonPrimitive("name").getAsString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getUserCountry() {
        if (userCountry == null) {
            try {
                String freeGeoIP = WebUtils.getWebResponse("https://www.creeperhost.net/json/datacentre/closest");
                JsonObject jObject = new JsonParser().parse(freeGeoIP).getAsJsonObject();
                jObject = jObject.getAsJsonObject("customer");
                userCountry = jObject.getAsJsonPrimitive("country").getAsString();
            }
            catch (Throwable t) {
                MineTogetherChat.logger.error("Unable to get user's country automatically, assuming USA", t);
                userCountry = "US";
            }
        }
        return userCountry;
    }

    public static Map<String, String> getRegionMap() {
        Map rawMap = new HashMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            String jsonData = WebUtils.getWebResponse("https://www.creeperhost.net/json/locations");
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Gson g2 = new Gson();
            JsonElement el = new JsonParser().parse(jsonData);
            rawMap = (Map)g2.fromJson(el.getAsJsonObject().get("regionMap"), type);
        }
        catch (Exception e) {
            MineTogetherChat.logger.error("Unable to fetch server locations" + e);
        }
        for (Map.Entry entry : rawMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            returnMap.put(key, value);
        }
        return returnMap;
    }

    public static Map<String, String> getDataCentres() {
        JsonArray array;
        String url = "https://www.creeperhost.net/json/datacentre/closest";
        String resp = WebUtils.getWebResponse(url);
        HashMap<String, String> map = new HashMap<String, String>();
        JsonElement jElement = new JsonParser().parse(resp);
        if (jElement.isJsonObject() && (array = jElement.getAsJsonObject().getAsJsonArray("datacentres")) != null) {
            for (JsonElement serverEl : array) {
                JsonObject object = (JsonObject)serverEl;
                String name = object.get("name").getAsString();
                String distance = object.get("distance").getAsString();
                map.put(name, distance);
            }
            return map;
        }
        return null;
    }

    public static boolean doesEmailExist(final String email) {
        try {
            JsonElement jElement;
            JsonObject jObject;
            String response = WebUtils.postWebResponse("https://www.creeperhost.net/json/account/exists", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("email", email);
                }
            });
            if (!response.equals("error") && (jObject = (jElement = new JsonParser().parse(response)).getAsJsonObject()).getAsJsonPrimitive("status").getAsString().equals("error")) {
                return false;
            }
        }
        catch (Throwable t) {
            MineTogetherChat.logger.error("Unable to check if email exists", t);
            return false;
        }
        return true;
    }

    public static String doLogin(final String username, final String password) {
        try {
            String response = WebUtils.postWebResponse("https://www.creeperhost.net/json/account/login", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("email", username);
                    this.put("password", password);
                }
            });
            if (!response.equals("error")) {
                JsonElement jElement = new JsonParser().parse(response);
                JsonObject jObject = jElement.getAsJsonObject();
                if (jObject.getAsJsonPrimitive("status").getAsString().equals("error")) {
                    return jObject.getAsJsonPrimitive("message").getAsString();
                }
                return "success:" + jObject.getAsJsonPrimitive("currency").getAsString() + ":" + jObject.getAsJsonPrimitive("userid").getAsString();
            }
            return "Unknown Error";
        }
        catch (Throwable t) {
            MineTogetherChat.logger.error("Unable to do login", t);
            return "Unknown Error";
        }
    }

    public static String createOrder(final Order order, final String modpackVersion, final String pregen) {
        try {
            String response = WebUtils.postWebResponse("https://www.creeperhost.net/json/order/" + order.clientID + "/" + order.productID + "/" + order.serverLocation, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("name", order.name);
                    this.put("swid", modpackVersion);
                    if (order.pregen) {
                        this.put("pregen", pregen);
                    }
                }
            });
            if (!response.equals("error")) {
                JsonElement jElement = new JsonParser().parse(response);
                JsonObject jObject = jElement.getAsJsonObject();
                if (jObject.getAsJsonPrimitive("status").getAsString().equals("success")) {
                    jObject = jObject.getAsJsonObject("more");
                    return "success:" + jObject.getAsJsonPrimitive("invoiceid").getAsString() + ":" + jObject.getAsJsonPrimitive("orderid").getAsString();
                }
                return jObject.getAsJsonPrimitive("message").getAsString();
            }
            return "Unknown error";
        }
        catch (Throwable t) {
            MineTogetherChat.logger.error("Unable to create order");
            return "Unknown error";
        }
    }

    public static String createAccount(final Order order, final String modpackVersion) {
        try {
            String response = WebUtils.postWebResponse("https://www.creeperhost.net/json/account/create", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("servername", order.name);
                    this.put("modpack", modpackVersion);
                    this.put("email", order.emailAddress);
                    this.put("password", order.password);
                    this.put("fname", order.firstName);
                    this.put("lname", order.lastName);
                    this.put("addr1", order.address);
                    this.put("city", order.city);
                    this.put("tel", order.phone);
                    this.put("county", order.state);
                    this.put("state", order.state);
                    this.put("country", order.country);
                    this.put("pcode", order.zip);
                    this.put("currency", order.currency);
                }
            });
            if (!response.equals("error")) {
                JsonElement jElement = new JsonParser().parse(response);
                JsonObject jObject = jElement.getAsJsonObject();
                if (jObject.getAsJsonPrimitive("status").getAsString().equals("error")) {
                    return jObject.getAsJsonPrimitive("message").getAsString();
                }
                return "success:" + jObject.getAsJsonPrimitive("currency").getAsString() + ":" + jObject.getAsJsonPrimitive("userid").getAsString();
            }
            return "Unknown error";
        }
        catch (Throwable t) {
            MineTogetherChat.logger.error("Unable to create account", t);
            return "Unknown error";
        }
    }

    public static String getPaymentLink(String invoiceID) {
        return "https://billing.creeperhost.net/viewinvoice.php?id=" + invoiceID;
    }

    public static boolean cancelOrder(int orderNum) {
        try {
            String string = WebUtils.getWebResponse("https://www.creeperhost.net/json/order/" + orderNum + "/cancel");
        }
        catch (Throwable t) {
            MineTogetherChat.logger.error("Unable to cancel order");
            return false;
        }
        return true;
    }

    static {
        countries = new LinkedHashMap<String, String>(){
            {
                this.put("GB", "United Kingdom");
                this.put("US", "United States");
                this.put("NZ", "New Zealand");
                this.put("AU", "Australia");
                this.put("DK", "Denmark");
                this.put("CA", "Canada");
                this.put("SE", "Sweden");
                this.put("NO", "Norway");
                this.put("BR", "Brazil");
                this.put("ES", "Spain");
                this.put("AF", "Afghanistan");
                this.put("AX", "Aland Islands");
                this.put("AL", "Albania");
                this.put("DZ", "Algeria");
                this.put("AS", "American Samoa");
                this.put("AD", "Andorra");
                this.put("AO", "Angola");
                this.put("AI", "Anguilla");
                this.put("AQ", "Antarctica");
                this.put("AG", "Antigua and Barbuda");
                this.put("AR", "Argentina");
                this.put("AM", "Armenia");
                this.put("AW", "Aruba");
                this.put("AT", "Austria");
                this.put("AZ", "Azerbaijan");
                this.put("BS", "Bahamas");
                this.put("BH", "Bahrain");
                this.put("BD", "Bangladesh");
                this.put("BB", "Barbados");
                this.put("BY", "Belarus");
                this.put("BE", "Belgium");
                this.put("BZ", "Belize");
                this.put("BJ", "Benin");
                this.put("BM", "Bermuda");
                this.put("BT", "Bhutan");
                this.put("BO", "Bolivia, Plurinational State of");
                this.put("BQ", "Bonaire, Sint Eustatius and Saba");
                this.put("BA", "Bosnia and Herzegovina");
                this.put("BW", "Botswana");
                this.put("BV", "Bouvet Island");
                this.put("IO", "British Indian Ocean Territory");
                this.put("BN", "Brunei Darussalam");
                this.put("BG", "Bulgaria");
                this.put("BF", "Burkina Faso");
                this.put("BI", "Burundi");
                this.put("KH", "Cambodia");
                this.put("CM", "Cameroon");
                this.put("CV", "Cape Verde");
                this.put("KY", "Cayman Islands");
                this.put("CF", "Central African Republic");
                this.put("TD", "Chad");
                this.put("CL", "Chile");
                this.put("CN", "China");
                this.put("CX", "Christmas Island");
                this.put("CC", "Cocos (Keeling) Islands");
                this.put("CO", "Colombia");
                this.put("KM", "Comoros");
                this.put("CG", "Congo");
                this.put("CD", "Congo, the Democratic Republic of the");
                this.put("CK", "Cook Islands");
                this.put("CR", "Costa Rica");
                this.put("CI", "C\ufffdte d'Ivoire");
                this.put("HR", "Croatia");
                this.put("CU", "Cuba");
                this.put("CW", "Cura\ufffdao");
                this.put("CY", "Cyprus");
                this.put("CZ", "Czech Republic");
                this.put("DJ", "Djibouti");
                this.put("DM", "Dominica");
                this.put("DO", "Dominican Republic");
                this.put("EC", "Ecuador");
                this.put("EG", "Egypt");
                this.put("SV", "El Salvador");
                this.put("GQ", "Equatorial Guinea");
                this.put("ER", "Eritrea");
                this.put("EE", "Estonia");
                this.put("ET", "Ethiopia");
                this.put("FK", "Falkland Islands (Malvinas)");
                this.put("FO", "Faroe Islands");
                this.put("FJ", "Fiji");
                this.put("FI", "Finland");
                this.put("FR", "France");
                this.put("GF", "French Guiana");
                this.put("PF", "French Polynesia");
                this.put("TF", "French Southern Territories");
                this.put("GA", "Gabon");
                this.put("GM", "Gambia");
                this.put("GE", "Georgia");
                this.put("DE", "Germany");
                this.put("GH", "Ghana");
                this.put("GI", "Gibraltar");
                this.put("GR", "Greece");
                this.put("GL", "Greenland");
                this.put("GD", "Grenada");
                this.put("GP", "Guadeloupe");
                this.put("GU", "Guam");
                this.put("GT", "Guatemala");
                this.put("GG", "Guernsey");
                this.put("GN", "Guinea");
                this.put("GW", "Guinea-Bissau");
                this.put("GY", "Guyana");
                this.put("HT", "Haiti");
                this.put("HM", "Heard Island and McDonald Islands");
                this.put("VA", "Holy Sea (Vatican City State)");
                this.put("HN", "Honduras");
                this.put("HK", "Hong Kong");
                this.put("HU", "Hungary");
                this.put("IS", "Iceland");
                this.put("IN", "India");
                this.put("ID", "Indonesia");
                this.put("IR", "Iran, Islamic Republic of");
                this.put("IQ", "Iraq");
                this.put("IE", "Ireland");
                this.put("IM", "Isle of Man");
                this.put("IL", "Israel");
                this.put("IT", "Italy");
                this.put("JM", "Jamaica");
                this.put("JP", "Japan");
                this.put("JE", "Jersey");
                this.put("JO", "Jordan");
                this.put("KZ", "Kazakhstan");
                this.put("KE", "Kenya");
                this.put("KI", "Kiribati");
                this.put("KP", "Korea, Democratic People's Republic of");
                this.put("KR", "Korea, Republic of");
                this.put("KW", "Kuwait");
                this.put("KG", "Kyrgyzstan");
                this.put("LA", "Lao People's Democratic Republic");
                this.put("LV", "Latvia");
                this.put("LB", "Lebanon");
                this.put("LS", "Lesotho");
                this.put("LR", "Liberia");
                this.put("LY", "Libya");
                this.put("LI", "Liechtenstein");
                this.put("LT", "Lithuania");
                this.put("LU", "Luxembourg");
                this.put("MO", "Macao");
                this.put("MK", "Macedonia, the former Yugoslav Republic of");
                this.put("MG", "Madagascar");
                this.put("MW", "Malawi");
                this.put("MY", "Malaysia");
                this.put("MV", "Maldives");
                this.put("ML", "Mali");
                this.put("MT", "Malta");
                this.put("MH", "Marshall Islands");
                this.put("MQ", "Martinique");
                this.put("MR", "Mauritania");
                this.put("MU", "Mauritius");
                this.put("YT", "Mayotte");
                this.put("MX", "Mexico");
                this.put("FM", "Micronesia, Federated States of");
                this.put("MD", "Moldova, Republic of");
                this.put("MC", "Monaco");
                this.put("MN", "Mongolia");
                this.put("ME", "Montenegro");
                this.put("MS", "Montserrat");
                this.put("MA", "Morocco");
                this.put("MZ", "Mozambique");
                this.put("MM", "Myanmar");
                this.put("NA", "Namibia");
                this.put("NR", "Nauru");
                this.put("NP", "Nepal");
                this.put("NL", "Netherlands");
                this.put("NC", "New Caledonia");
                this.put("NI", "Nicaragua");
                this.put("NE", "Niger");
                this.put("NG", "Nigeria");
                this.put("NU", "Niue");
                this.put("NF", "Norfolk Island");
                this.put("MP", "Northern Mariana Islands");
                this.put("OM", "Oman");
                this.put("PK", "Pakistan");
                this.put("PW", "Palau");
                this.put("PS", "Palestinian Territory, Occupied");
                this.put("PA", "Panama");
                this.put("PG", "Papua New Guinea");
                this.put("PY", "Paraguay");
                this.put("PE", "Peru");
                this.put("PH", "Philippines");
                this.put("PN", "Pitcairn");
                this.put("PL", "Poland");
                this.put("PT", "Portugal");
                this.put("PR", "Puerto Rico");
                this.put("QA", "Qatar");
                this.put("RE", "R\ufffdunion");
                this.put("RO", "Romania");
                this.put("RU", "Russian Federation");
                this.put("RW", "Rwanda");
                this.put("BL", "Saint Barth\ufffdlemy");
                this.put("SH", "Saint Helena, Ascension and Tristan da Cunha");
                this.put("KN", "Saint Kitts and Nevis");
                this.put("LC", "Saint Lucia");
                this.put("MF", "Saint Martin (French part)");
                this.put("PM", "Saint Pierre and Miquelon");
                this.put("VC", "Saint Vincent and the Grenadines");
                this.put("WS", "Samoa");
                this.put("SM", "San Marino");
                this.put("ST", "Sao Tome and Principe");
                this.put("SA", "Saudi Arabia");
                this.put("SN", "Senegal");
                this.put("RS", "Serbia");
                this.put("SC", "Seychelles");
                this.put("SL", "Sierra Leone");
                this.put("SG", "Singapore");
                this.put("SX", "Sint Maarten (Dutch part)");
                this.put("SK", "Slovakia");
                this.put("SI", "Slovenia");
                this.put("SB", "Solomon Islands");
                this.put("SO", "Somalia");
                this.put("ZA", "South Africa");
                this.put("GS", "South Georgia and the South Sandwich Islands");
                this.put("SS", "South Sudan");
                this.put("LK", "Sri Lanka");
                this.put("SD", "Sudan");
                this.put("SR", "Suriname");
                this.put("SJ", "Svalbard and Jan Mayen");
                this.put("SZ", "Swaziland");
                this.put("CH", "Switzerland");
                this.put("SY", "Syrian Arab Republic");
                this.put("TW", "Taiwan, Province of China");
                this.put("TJ", "Tajikistan");
                this.put("TZ", "Tanzania, United Republic of");
                this.put("TH", "Thailand");
                this.put("TL", "Timor-Leste");
                this.put("TG", "Togo");
                this.put("TK", "Tokelau");
                this.put("TO", "Tonga");
                this.put("TT", "Trinidad and Tobago");
                this.put("TN", "Tunisia");
                this.put("TR", "Turkey");
                this.put("TM", "Turkmenistan");
                this.put("TC", "Turks and Caicos Islands");
                this.put("TV", "Tuvalu");
                this.put("UG", "Uganda");
                this.put("UA", "Ukraine");
                this.put("AE", "United Arab Emirates");
                this.put("UM", "United States Minor Outlying Islands");
                this.put("UY", "Uruguay");
                this.put("UZ", "Uzbekistan");
                this.put("VU", "Vanuatu");
                this.put("VE", "Venezuela, Bolivarian Republic of");
                this.put("VN", "Viet Nam");
                this.put("VG", "Virgin Islands, British");
                this.put("VI", "Virgin Islands, U.S.");
                this.put("WF", "Wallis and Futuna");
                this.put("EH", "Western Sahara");
                this.put("YE", "Yemen");
                this.put("ZM", "Zambia");
                this.put("ZW", "Zimbabwe");
                this.put("UNKNOWN", "Unknown");
            }
        };
    }
}

