/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.irc;

import java.util.regex.Pattern;

public enum Format {
    BLACK(1),
    BLUE(12),
    BOLD('\u0002'),
    BROWN(5),
    CYAN(11),
    DARK_BLUE(2),
    DARK_GRAY(14),
    DARK_GREEN(3),
    GREEN(9),
    ITALIC('\u001d'),
    LIGHT_GRAY(15),
    MAGENTA(13),
    RESET('\u000f'),
    OLIVE(7),
    PURPLE(6),
    RED(4),
    REVERSE('\u0016'),
    TEAL(10),
    UNDERLINE('\u001f'),
    WHITE(0),
    YELLOW(8);

    private final int color;
    private final boolean isColor;
    private final String toString;
    public static final char COLOR_CHAR = '\u0003';
    private static final Pattern COLOR_REGEX;
    private static final Pattern FORMAT_REGEX;

    private Format(char ch) {
        this.color = -1;
        this.isColor = false;
        this.toString = String.valueOf(ch);
    }

    private Format(int color) {
        this.color = color;
        this.isColor = true;
        this.toString = '\u0003' + (color < 10 ? "0" : "") + color;
    }

    public static String stripAll(String input) {
        return Format.stripColor(Format.stripFormatting(input));
    }

    public static String stripColor(String input) {
        return COLOR_REGEX.matcher(input).replaceAll("");
    }

    public static String stripFormatting(String input) {
        return FORMAT_REGEX.matcher(input).replaceAll("");
    }

    public boolean isColor() {
        return this.isColor;
    }

    public int getColorChar() {
        return this.color;
    }

    public String toString() {
        return this.toString;
    }

    static {
        COLOR_REGEX = Pattern.compile("\u0003[0-9]{1,2}");
        FORMAT_REGEX = Pattern.compile("[" + (Object)((Object)BOLD) + (Object)((Object)RESET) + (Object)((Object)REVERSE) + (Object)((Object)UNDERLINE) + ']');
    }
}

